<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\LoyaltiesModel;

class LoyaltiesController extends BaseController
{
    //construct function
    public function __construct()
    {
        $this->loyalties = new LoyaltiesModel();    
        $this->db = \Config\Database::connect();     
        helper(['url','form','app']);
    }
    //insert/update data
    public function submit()
     {
        $user_info = getUserInfo();
        $validation = $this->validate([
            'type' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select type',
                ],
            ],
            'margin' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter margin',
                ],
            ],
            'rate' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter rate',
                ],
            ],
        ]);
        $id = $this->request->getVar('id');
        $session = session();
        if($validation){
            if($id == ''){  
                //insert
                $data = [
                    'type' => $this->request->getVar('type'),
                    'margin'  => $this->request->getVar('margin'),
                    'rate'  => $this->request->getVar('rate'),
                    'created_at' => date('Y-m-d H:i:s'),
                    'created_by' =>  $user_info->UserID,
                ];
            //set trans status
            $transaction_status = false;
            //---begin transaction---
            $this->db->transBegin();

                $this->loyalties->insertData($data);
                if ($this->db->transStatus() === FALSE){
                    //---rollback transaction
                    $this->db->transRollback();
                    $transaction_status = false;
                       // Set the success flash message
                    $session->setFlashdata('title', 'Error');
                    $session->setFlashdata('icon', 'warning');
                    $session->setFlashdata('message', 'Something Went wrong.');  
                }
                else{
                    //---commit transaction
                    $this->db->transCommit();
                    $transaction_status = true;
                   // Set the success flash message
                    $session->setFlashdata('title', 'Saved');
                    $session->setFlashdata('icon', 'success');
                    $session->setFlashdata('message', 'Loyalty details saved successfully.'); 
                }     
            }
            else{   
                //update
                $data = [
                    'type' => $this->request->getVar('type'),
                    'margin'  => $this->request->getVar('margin'),
                    'rate'  => $this->request->getVar('rate'),
                    'updated_at' => date('Y-m-d H:i:s'),
                    'updated_by' =>  $user_info->UserID,
                ];
                $this->loyalties->updateData($id, $data);
                     // Set the success flash message
          $session->setFlashdata('title', 'Saved');
          $session->setFlashdata('message', 'Loyalty details updated successfully.');
            }
            return $this->response->redirect(site_url('/loyalties'));
        }
        else{
            $user_info = getUserInfo();
            $records['Loyalties'] = $this->loyalties->index();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Loyalties',
                'link' => 'loyalties',
                'sources' => $records,
                'userinfo' => $user_info,
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
            );
            return view('/loyalties', $data);
        }
     }
    //get specific data
    public function getSpecificData($id = null) 
    {
        $data=$this->loyalties->getSpecificData($id);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }
    //get all data
    public function index()
    {
        $user_info = getUserInfo();
        $records['Loyalties'] = $this->loyalties->index();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Loyalties',
            'link' => 'loyalties',
            'sources' => $records,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        // echo '<pre>';
        // print_r($records);
        //   die();
        return view('loyalties', $data);
    }
    // delete data
    public function delete($id = null)
    {
        $user_info = getUserInfo();
        $data = [
            'deleted_at' => date("Y-m-d H:i:s"),
            'delete_flag' => 1,
            'deleted_by' =>  $user_info->UserID,
        ];
        $this->loyalties->deleteData($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    } 
      // Payment Type disable
    public function disableloyalty($id = null)
    {
          $data = [
              'current_status' => '2'
          ];
          if($this->loyalties->statusupdate($id, $data)):                
              echo json_encode(array('status'=>true));
          endif;
    }
      // Payment Type enable
    public function enableloyalty($id = null)
    {
          $data = [
              'current_status' => '1'
          ];
          if($this->loyalties->statusupdate($id, $data)):                
              echo json_encode(array('status'=>true));
          endif;
    }
}
