<?php

namespace App\Controllers;
use App\Models\UserModel;
use App\Models\ItemLocationsModel;
use App\Models\ItemBinsModel;
use App\Models\LocationModel;
use App\Models\StocksModel;
use App\Controllers\BaseController;
use App\Models\CommonModel;

class LocationsController extends BaseController
{
    private $ItemLocationsModel = null;
    private $ItemBinsModel = null;
    // private $LocationsModel = null;
    private $now = null;

    public function __construct()
    {
        $this->ItemLocationsModel = new ItemLocationsModel();
        $this->LocationsModel = new LocationModel();
        $this->ItemBinsModel = new ItemBinsModel();
        $this->StocksModel = new StocksModel();
        $this->common = new CommonModel();   
        $this->now = date("Y-m-d H:i:s");   
        helper(['url','form','app']);
    }


    // Location Based - insert data
    public function locationInsert()
    {
        $user_info = getUserInfo();     
        $validation = $this->validate([
            'LocationName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please Enter the Location Name',
                ],
            ],
         
        ]);
        $locationid = $this->request->getVar('locid');
        $session = session();
        if($validation){
            if($locationid == ''){  //Insert Item Location
                $data = [
                    'LocationName' => $this->request->getVar('LocationName'),
                    'LStatus' => '1',
                    'LCreaterAt' => $this->now,
                    'LCreaterBy' => $user_info->UserID,
                ];
                $this->LocationsModel->insertLocationsData($data);
                 // Set the success flash message
                 $session->setFlashdata('title', 'Saved');
                 $session->setFlashdata('message', 'Location details saved successfully.');
            }else{   //Update Item Location
                $data = [
                    'LocationName' => $this->request->getVar('LocationName'),
                    'LUpdatedAt' => $this->now,
                    'LUpdatedBy' => $user_info->UserID,
                ];
                $this->LocationsModel->updateLocationsData($locationid, $data);
                // Set the success flash message
                $session->setFlashdata('title', 'Saved');
                $session->setFlashdata('message', 'Location details updated successfully.');
            }
            return $this->response->redirect(site_url('/locationsview'));
        }else{
            $user_info = getUserInfo();
            $locations['locations'] = $this->LocationsModel->getAllLocations();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'locationsview',
                'link' => 'locationsview',
                'sources' => $locations,
                'userinfo' => $user_info,
                'storingtypes' => 'Bin',
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
            );
            return view('/locationsview', $data);
        }
    } 

    
    public function index()
    {
        $user_info = getUserInfo();
        $locations['locations'] = $this->LocationsModel->getAllLocations();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
                'title' => 'locationsview',
                'link' => 'locationsview',
                'sources' => $locations,
                'userinfo' => $user_info,
                'storingtypes' => 'Bin',
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
        );
        return view('/locationsview', $data);
    }

    // Location Based - get single data
    public function locationSingleData($id = null) 
    {        
        $data=$this->LocationsModel->getSingleLocationData($id);
       
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    //  Location Based - delete
    public function locationDelete($id = null)
    {
        $user_info = getUserInfo();     
        $has_itemlocations_info = $this->common->checkForeignKeyConstraints("itemlocations","LocationID",$id,"ILStatus",1);
         //define message
         $msg_prefix = 'This location has ';
         $msg_itemlocations_info = 'item locations information';
         $msg = '';
         if($has_itemlocations_info  ){
             $msg = $msg_prefix.$msg_itemlocations_info;
         }
        $data = [
            'LDeletedAt' => $this->now,
            'LDeletedBy' => $user_info->UserID,
            'LStatus' => '0',
        ];
        if($has_itemlocations_info){
            //    if($has_price_rule_info ){
                return $this->response->setJSON([
                    'error' => true,
                    'message' => $msg
                ]);
            }
            else{
                $this->LocationsModel->deleteLocations($id, $data);
                return $this->response->setJSON([
                    'error' => false,
                    'message' => 'Successfully deleted!'
                ]);
            }
      
    }

    // Bin Based - insert data
    public function binInsert()
    {
        $validation = $this->validate([
            'itemBinLocationId' => [
                'rules'=>'required|matches["Default"]',
                'errors'=>[
                    'required'=>'Please select the Location Name',
                    'matches'=>'Default value is not considerable!',
                ],
            ],
            'itemBinLocatonName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please Enter the Bin Location Name',
                ],
            ],
            'IBItem' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select the Item',
                ],
            ],
            'IBBatchNo' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select the Batch No',
                ],
            ],
            'IBQtyLevel' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please Enter the Location QTY Level',
                ],
            ],
        ]);
        if($validation){
            $itembinlocationid = $this->request->getVar('itemBinId');
            if($itembinlocationid == ''){  //Insert Item Location
                $data = [
                    'ILID' => $this->request->getVar('itemBinLocationId'),
                    'IBName'  =>  $this->request->getVar('itemBinLocatonName'),
                    'ItemID'  =>  $this->request->getVar('IBItem'),
                    'BatchNo'  => $this->request->getVar('IBBatchNo'),
                    'ILQtyLevel'  => $this->request->getVar('IBQtyLevel'),
                    'IBStatus' => '1',
                    'IBCreaterAt' => $this->now,
                ];
                $this->model->insertLocationBins($data);
            }else{   //Update Item Location
                $data = [
                    'IBName' => $this->request->getVar('itemBinLocationId'),
                    'IBName'  =>  $this->request->getVar('itemBinLocatonName'),
                    'ItemID'  =>  $this->request->getVar('IBItem'),
                    'BatchNo'  => $this->request->getVar('IBBatchNo'),
                    'IBQtyLevel'  => $this->request->getVar('IBQtyLevel'),
                    'IBUpdatedAt' => $this->now,
                ];
                $this->model->updateItemLocationBins($itembinlocationid, $data);
            }
            return $this->response->redirect(site_url('/locations'));
        }else{
            $user_info = getUserInfo();
            $ItemLocations = $this->ItemLocationsModel->getAllLocations();
            $ItemLocationBins = $this->ItemBinsModel->getAllLocationbins();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Locations',
                'link' => 'locations',
                'ItemLocations' => $ItemLocations,
                'ItemLocationBins' => $ItemLocationBins,
                'userinfo' => $user_info,
                'storingtypes' => 'Bin',
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
            );
            return view('/locations', $data);
        }
    }
    
    // Bin Based - get single data
    public function binSingleData($id = null) 
    {        
        $data=$this->ItemBinsModel->getSingleLocationBinsData($id);
       
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    // Bin Based - Delete
    public function binDelete($id = null)
    {
        $data = [
            'IBDeletedAt' => $this->now,
            'IBStatus' => '0',
        ];

        $this->ItemBinsModel->deleteItemLocationBins($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    } 
}
