<?php

    namespace App\Controllers;
    
    use App\Models\UserModel;
    use App\Models\ItemsModel;
    use App\Models\ItemCategoryModel;
    use App\Models\UnitsModel;
    use App\Models\StocksModel;
    use App\Models\ItemUnitsModel;
    use App\Models\CommonModel;
    use App\Controllers\BaseController;

    class ItemsController extends BaseController
    {   
        private $UserModel = null;
        private $UnitsModel = null;
        private $ItemsModel = null;
        private $ItemCategoryModel = null;
        private $StocksModel = null;
        private $ItemUnitsModel = null;
        private $now = null;
    
        public function __construct()
        {
            $this->UserModel = new UserModel();
            $this->UnitsModel = new UnitsModel();
            $this->ItemsModel = new ItemsModel();
            $this->ItemCategoryModel = new ItemCategoryModel();
            $this->StocksModel = new StocksModel();
            $this->ItemUnitsModel = new ItemUnitsModel();
            $this->common = new CommonModel(); 
            $this->now = date("Y-m-d H:i:s");
            $this->db = \Config\Database::connect();
            helper(['url','form','app']);
        }       

        public function getItems()
        {
            $data = $this->ItemsModel->getItemIndexData();
        }

        // public function saveandrec()
        // {
        //     $data = [           
        //         'ItemName' => $_POST['ItemName'],
        //         'ItemCategory' => $_POST['ItemCategory'],
        //         'ItemTags' => $_POST['ItemTags'],
        //         'ItemDescription' => $_POST['ItemDescription'],
        //         'ItemUnit' => $_POST['ItemUnit'],
        //         'ItemReorderLevel' => $_POST['ItemReorderLevel'],
        //         'ItemIsSerialized' =>  $_POST['ItemIsSerialized'],
        //         'ItemStatus' =>  '1',
        //         'ItemCreatedAt' => $this->now,               
        //     ];
      
        //     if(!empty($_FILES['ItemImg']['name'])){                
        //         $imageFile = $this->request->getFile('ItemImg');
        //         $imageFile->move('../public/uploads/itemImg');
        //         $imgDetail =$_FILES['ItemImg'];
        //         $data['ItemImg']= $imgDetail ['name'];            
        //     }
        //     $this->ItemsModel->insert($data);
        //     $data['ItemID'] = $this->ItemsModel->getInsertID();
        //     if($data){
        //         echo json_encode(array('data' => $data));
        //     }else{
        //         echo json_encode(array('data' => $data, "status" => false));
        //     }
        // }

        // item insert
        public function save()
        {
            $user_info = getUserInfo();
            $validation = $this->validate([
                'ItemName' => [
                   // 'rules'=>'required|is_not_unique[phppos_item.ItemName]',
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please Enter Item Name',
                       // 'is_not_unique'=>'Item already exisit.',
                    ],
                ],
                'ItemTags' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please enter tag name',
                    ],
                ],
                'ItemDescription' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please enter Item Description',
                    ],
                    
                ],
                'ItemUnit' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please choose the Base Unit',
                    ],
                    
                ],
                'ItemReorderLevel' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please enter value',
                    ],
                ],
                'ItemCategory' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please select a Category',
                    ],
                ],
                'ItemType' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please select a Item Type',
                    ],
                ],
                'ItemStatusValue' => [
                    'rules'=>'required',
                    'errors'=>[
                        'required'=>'Please select a Item Status',
                    ],
                ],
            ]);
            $iID = $this->request->getVar('ItemID');
            $session = session();
            if($validation){
                //serialized
                if($this->request->getVar('ItemReturnable')=='0'){
                    $ItemReturnable = 0;
                }else{
                    $ItemReturnable = 1;
                }

                //returnable 
                if(isset($_POST['ItemIsSerialized'])){
                    $ItemIsSerialized = 1;
                }else{
                    $ItemIsSerialized = 0;
                }

                if($iID == ''){  //insert item details
                    $data = [            
                        'ItemName' =>  $this->request->getVar('ItemName'),
                        'ItemCategory' =>$this->request->getVar('ItemCategory'), 
                        'ItemTags' =>$this->request->getVar('ItemTags'), 
                        'ItemDescription' => $this->request->getVar('ItemDescription'), 
                        'ItemUnit' => $this->request->getVar('ItemUnit'),
                        'ItemReorderLevel' => $this->request->getVar('ItemReorderLevel'),
                        'ItemIsSerialized' =>  $ItemIsSerialized,
                        'ItemType'=>$this->request->getVar('ItemType'),
                        'ItemStatusValue'=>$this->request->getVar('ItemStatusValue'),
                        'ItemReturnable'=>$ItemReturnable,
                        'delete_flag' =>  '0',
                        'ItemCreatedAt' => $this->now,    
                        'ItemCreatedBy' => $user_info->UserID,            
                    ];
                    if($this->request->getVar('ItemOtherUnits')){
                        $array =  $this->request->getVar('ItemOtherUnits');
                        $data['ItemOtherUnits'] = implode(',',$array);
                    }
                    if(!empty($_FILES['ItemImg']['name'])){                
                        $imageFile = $this->request->getFile('ItemImg');
                        $imageFile->move('../public/uploads/itemImg');
                        $imgDetail =$_FILES['ItemImg'];
                        $data['ItemImg']= $imgDetail ['name'];            
                    }
                      //set trans status
                    $transaction_status = false;
                    //---begin transaction---
                    $this->db->transBegin();

                    $last_id = $this->ItemsModel->insertItemData($data);
                    $IOUnits = $this->request->getVar('ItemOtherUnits');
                    if($IOUnits):
                        if($last_id):
                            $ItemUnitsData = [];
                            foreach($IOUnits as $IOUnit):
                                $ItemUnitsData = [
                                    'ItemID' =>  $last_id,
                                    'OtherUnits' => $IOUnit,
                                    'ItemUnitStatus' => '1'
                                ];
                                $this->ItemUnitsModel->insertItemUnitsData($ItemUnitsData);
                            endforeach;
                        endif;
                    endif;

                    if ($this->db->transStatus() === FALSE){
                        //---rollback transaction
                        $this->db->transRollback();
                        $transaction_status = false;
                           // Set the success flash message
                $session->setFlashdata('title', 'Error');
                $session->setFlashdata('icon', 'warning');
                $session->setFlashdata('message', 'Something Went wrong.');  
                    }
                    else{
                        //---commit transaction
                        $this->db->transCommit();
                        $transaction_status = true;
                       // Set the success flash message
                $session->setFlashdata('title', 'Saved');
                $session->setFlashdata('icon', 'success');
                $session->setFlashdata('message', 'Item details saved successfully.'); 
                    }                                           
                }else{  //update item details
                    $data = [
                        'ItemName' => $this->request->getVar('ItemName'),
                        'ItemCategory'  => $this->request->getVar('ItemCategory'),
                        'ItemTags'  => $this->request->getVar('ItemTags'),
                        'ItemDescription'  => $this->request->getVar('ItemDescription'),
                        'ItemUnit'  => $this->request->getVar('ItemUnit'),
                        'ItemReorderLevel'  => $this->request->getVar('ItemReorderLevel'),
                        'ItemIsSerialized' =>  $ItemIsSerialized,
                        'ItemType'=>$this->request->getVar('ItemType'),
                        'ItemStatusValue'=>$this->request->getVar('ItemStatusValue'),
                        'ItemReturnable'=>$ItemReturnable,
                        'ItemUpdatedAt' => $this->now,   
                        'ItemUpdatedBy' => $user_info->UserID, 
                    ];
                    if($this->request->getVar('ItemOtherUnits')){
                        $array =  $this->request->getVar('ItemOtherUnits');
                        $data['ItemOtherUnits'] = implode(',',$array);
                    }
                    if(!empty($_FILES['ItemImg']['name'])){ 
                        $imageFile = $this->request->getFile('ItemImg');
                        $imageFile->move('../public/uploads/itemImg');
                        $imgDetail =$_FILES['ItemImg'];
                        $data['ItemImg']= $imgDetail ['name'];
                    }
                    $this->ItemsModel->updateItem($iID, $data);
                    $IOUnits = $this->request->getVar('ItemOtherUnits');
                    if($IOUnits):
                        if($iID):
                            $deletePrevData = $this->ItemUnitsModel->deleteitemunits($iID);
                            if($deletePrevData):
                                $ItemUnitsData = [];
                                foreach($IOUnits as $IOUnit):
                                    $ItemUnitsData = [
                                        'ItemID' =>  $iID,
                                        'OtherUnits' => $IOUnit,
                                        'ItemUnitStatus' => '1'
                                    ];
                                    $this->ItemUnitsModel->insertItemUnitsData($ItemUnitsData);
                                endforeach;
                            endif;
                        endif;
                    endif;
                        // Set the success flash message
                $session->setFlashdata('title', 'Updated');
                $session->setFlashdata('message', 'Item updated successfully.');  
                $session->setFlashdata('icon', 'success');                              
                }
                $this->response->redirect(site_url('/items'));
            }else{
                $user_info = getUserInfo();
                $ItemCategories = $this->ItemCategoryModel->getAllCategories();
                $itemData = $this->ItemsModel->getItemIndexData();
                $Units = $this->UnitsModel->getIndexData();
                $has_errors = 'true';
                $data = array(
                    'breadcrumbs' => 'true',
                    'title' => 'Items',
                    'link' => 'items',
                    'sources' => $itemData,
                    'ItemCategories' => $ItemCategories,
                    'Units' => $Units,
                    'userinfo' => $user_info,
                    'validation'=>$this->validator,
                    'has_errors' => $has_errors,
                );
                return view('/items', $data);
            }
        }

        public function index()
        {
            $ItemCategories = $this->ItemCategoryModel->getAllActiveCategories();
            $itemData = $this->ItemsModel->getItemIndexData();
            $Units = $this->UnitsModel->getAllActiveUnitsData();    
            $loggedUserID = session()->get('loggedUser');
            $user_info = $this->UserModel->getSingleUserData($loggedUserID);
            $has_errors = 'false';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Items',
                'link' => 'items',
                'sources' => $itemData,
                'ItemCategories' => $ItemCategories,
                'Units' => $Units,
                'userinfo' => $user_info,
                'has_errors' => $has_errors,
            );
            return view('items', $data);
        }
        //get single data
        public function singleData($id = null)
        {
            $data = $this->ItemsModel->getSingleItemUnitData($id);
            if($data){
                echo json_encode(array("status" => true, 'icon' => 'Sucess', 'title' => 'Values from DB', 'data' => $data));
            }else{
                echo json_encode(array("status" => false,  'icon' => 'eError', 'title' => 'Oops....!', 'data' => $data));
            }
        }
        // delete
        public function delete($id = null)
        {
            $user_info = getUserInfo();
            $has_itembins_info = $this->common->checkForeignKeyConstraints("itembins","ItemID",$id,"IBStatus",1);
            $has_itemlocations_info = $this->common->checkForeignKeyConstraints("itemlocations","ItemID",$id,"ILStatus",1);
            $has_price_rules_info = $this->common->checkForeignKeyConstraints("price_rules","pr_items",$id,"pr_status",1);
            $has_stocks_info = $this->common->checkForeignKeyConstraints("stocks","ItemID",$id,"StockStatus",1);
            $has_itemunits_info = $this->common->checkForeignKeyConstraints("itemunits","ItemID",$id,"ItemUnitStatus",1);
            $has_sale_items_info = $this->common->checkForeignKeyConstraints("sale_items","item_id",$id,"delete_flag",0);
            $has_temp_itemserialized_info = $this->common->checkForeignKeyConstraints("temp_itemserialized","item_id",$id,"delete_flag",0);
            $has_receivingdetails_info = $this->common->checkForeignKeyConstraints("receivingdetails","ItemID",$id,"RDStatus",1);
            $has_item_serialized_info = $this->common->checkForeignKeyConstraints("item_serialized","item_id",$id,"delete_flag",0);
            $has_temp_receivingdetails_info = $this->common->checkForeignKeyConstraints("temp_receivingdetails","ItemID",$id,"RDStatus	",1);

              //define message
            $msg_prefix = 'This item has ';
            // $msg_itemunits_info = 'item units information';
            $msg_receivingdetails_info = ' receiving details information  ';
            $msg = '';
            if($has_receivingdetails_info){
                $msg = $msg_prefix.$msg_receivingdetails_info;
            }
            
            $data = [            
                'delete_flag' => '1',
                'ItemDeletedBy' => $user_info->UserID,
                'ItemDeletedAt' => $this->now,
            ];

        
            if($has_itembins_info || $has_itemlocations_info || $has_price_rules_info||$has_stocks_info || $has_itemunits_info || $has_sale_items_info||$has_temp_itemserialized_info
             || $has_receivingdetails_info || $has_item_serialized_info||  $has_temp_receivingdetails_info){
                //    if($has_itemlocations_info|| $has_price_rules_info||$has_stocks_info || $has_itemunits_info || $has_sale_items_info ){
                    return $this->response->setJSON([
                        'error' => true,
                        'message' => $msg
                    ]);
                }
                else{
                    $this->ItemsModel->deleteitem($id, $data);
                    return $this->response->setJSON([
                        'error' => false,
                        'message' => 'Successfully deleted!'
                    ]);
                }
            
          
        }
        // item - turn off serilize
        public function offserialize($id = null)
        {
            $data = [
                'ItemIsSerialized' => '0'
            ];

            if($this->ItemsModel->statusupdate($id, $data)):                
                echo json_encode(array('status'=>true));
            endif;
        }
       // item - turn on serilize
        public function onserialize($id = null)
        {
            $data = [
                'ItemIsSerialized' => '1'
            ];

            if($this->ItemsModel->statusupdate($id, $data)):                
                echo json_encode(array('status'=>true));
            endif;
        }
        // item disable
        public function disableitem($id = null)
        {
            $data = [
                'current_status' => '2'
            ];         
            if($this->ItemsModel->statusupdate($id, $data)):                
                echo json_encode(array('status'=>true));
            endif;
        }
        // item enable
        public function enableitem($id = null)
        {
            $data = [
                'current_status' => '1'
            ];
            if($this->ItemsModel->statusupdate($id, $data)):                
                echo json_encode(array('status'=>true));
            endif;
        }
        //get item data by item id
        public function getItemData($id = null)
        {
            $data=$this->ItemsModel->getItemData($id);
            if($data){
                echo json_encode(array("status" => true , 'data' => $data));
            }else{
                echo json_encode(array("status" => false));
            }
        }
    }
?>