<?php

namespace App\Controllers;

use App\Models\ItemCategoryModel;
use App\Models\ItemsCategoryInfomationModel;
use App\Models\ItemsCategoryDetailsModel;
use App\Models\CommonModel;
use App\Controllers\BaseController;

class ItemsCategoryInfomationController extends BaseController
{
    protected $session;

    public function __construct()
    {   
        $this->ItemCategoryModel = new ItemCategoryModel();
        $this->itemCategoryInformationModel = new ItemsCategoryInfomationModel(); 
        $this->itemCategoryDetailModel= new  ItemsCategoryDetailsModel();
        $this->common = new CommonModel();
        $this->session = \Config\Services::session();
        $this->now = date("Y-m-d H:i:s");
        $this->db = \Config\Database::connect();
        helper(['url','form','app']);
    }

    public function index()
    {
        $user_info = getUserInfo();
        $records = $this->itemCategoryInformationModel->index();
        $has_errors = 'false';
        $data = [
            'breadcrumbs' => 'true',
            'title' => 'CustomerContactInformation',
            'link' => 'customer_contact_information',
            'sources' => $records,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        ];
        return view('item_category_information', $data);
    }
    
    public function insert()
    {   $session = session();
        $user_info = getUserInfo();      
        $validation = $this->validate([
            'ICName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter category name',
                ],
            ],
        ]);
        $icId = $this->request->getVar('ICID');
        if($validation){ 
            if($icId == ''){
                $user_info = getUserInfo();
                if($this->request->getVar('ICParentID') != ''){
                    $level = $this->checkLevel($this->request->getVar('ICParentID'));
                }else{                    
                    $level = '0';
                }
                //var_dump($level);
                $records['categoryInfo'] = $this->itemCategoryInformationModel->index();
                $data = [
                    'ICName' => $this->request->getVar('ICName'),
                    'ICLink'  => strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
                    'ICParentID'  => $this->request->getVar('ICParentID'),
                    'ICLevel'  => $level,
                    'ICCreatedAt' => $this->now,       
                    'ICCreatedBy' => $user_info->UserID,       
                    'delete_flag'=>'0',
                ];
                if(($this->request->getVar('ICParentID'))){
                    $parentId = $this->request->getVar('ICParentID');
                    $parentCatData = $this->itemCategoryInformationModel->getSpecificData($parentId);
                    $ICParentCatName=$parentCatData->ICName;
                    $data['ICParentCatName']= $ICParentCatName;
                }
                $db = \Config\Database::connect();   
                  //set trans status
                    $transaction_status = false;
                    //---begin transaction---
                    $this->db->transBegin();    
                $this->itemCategoryInformationModel->insertData($data);
                $lastInsertedCatID = $db->insertID();           
                $catcheck = $this->itemCategoryInformationModel->getCatCheckData($lastInsertedCatID);    
                $parentID = $catcheck->ICParentID;
                if(!$parentID){
                    $path = $this->request->getVar('ICName');  
                }else{                
                    $parentCheck = $this->itemCategoryInformationModel->getCatCheckData($parentID);
                    $path = $parentCheck->ICName;
                }
                if($lastInsertedCatID){
                    $catdetailsdata = [
                        'ICID' => $lastInsertedCatID,
                        'ICPath' => $path,
                        'ICLink' => strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
                        'ICCreatedBy' => $user_info->UserID,
                        'ICDStatus' => '1',
                    ];
                    $this->itemCategoryDetailModel->insert($catdetailsdata);
                }
                if ($this->db->transStatus() === FALSE){
                    //---rollback transaction
                    $this->db->transRollback();
                    $transaction_status = false;
                          // Set the success flash message
                    $session->setFlashdata('title', 'Error');
                    $session->setFlashdata('icon', 'warning');
                    $session->setFlashdata('message', 'Error Occured.');
                }
                else{
                    //---commit transaction
                    $this->db->transCommit();
                    $transaction_status = true;
                    $session->setFlashdata('title', 'success');
                    $session->setFlashdata('icon', 'success');
                    $session->setFlashdata('message', 'Category inserted successfully.');
                }

                // Redirect back to the form or any other page
                return redirect()->back();
                //return $this->response->redirect(site_url('/item_category_information'));
            }else{
                if($this->request->getVar('ICParentID') != ''){
                    $level = $this->checkLevel($this->request->getVar('ICParentID'));
                }else{                    
                    $level = '0';
                }
                $data = [
                    'ICName' => $this->request->getVar('ICName'),
                    'ICLink'  => strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
                    'ICParentID'  => $this->request->getVar('ICParentID'),
                    'ICLevel'  => $level,
                    'ICUpdatedBy' => $user_info->UserID,
                    'ICUpdatedAt' => $this->now,              
                ];
                if(($this->request->getVar('ICParentID'))){
                    $parentId = $this->request->getVar('ICParentID');
                    $parentCatData = $this->itemCategoryInformationModel->getSpecificData($parentId);
                    $ICParentCatName=$parentCatData->ICName;
                    $data['ICParentCatName']= $ICParentCatName;
                }
                $this->itemCategoryInformationModel->updateData($icId, $data);
                
                // Set a success flash message
                $this->session->setFlashdata('success', 'Category Updated successfully.');

                // Redirect back to the form or any other page
                return redirect()->back();
                //return $this->response->redirect(site_url('/item_category_information'));
            }  
        }else{
            $user_info = getUserInfo();
            $records = $this->itemCategoryInformationModel->index();
            $has_errors = 'true';
            $data = [
                'breadcrumbs' => 'true',
                'title' => 'CustomerContactInformation',
                'link' => 'customer_contact_information',
                'sources' => $records,
                'userinfo' => $user_info,
                'has_errors' => $has_errors,
                'validation'=>$this->validator,              
            ];          
            return view('item_category_information', $data);
        }
    }

    //get specific data
    public function singleData($id = null)
    {
        $data=$this->itemCategoryInformationModel->getSpecificData($id);
        if($data){//var_dump($data);exit();
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }
  
     // delete data
     public function delete($id = null )
     {
        $user_info = getUserInfo();
        $has_item_info = $this->common->checkForeignKeyConstraints("item","ItemCategory",$id,"delete_flag",0);
        $has_child_category_info = $this->common->checkForeignKeyConstraints("itemcategory","ICParentID",$id,"delete_flag",0);
        //define message
        $msg_prefix = 'This category has ';
        $msg_item_info = 'item information';
        $msg_category_info = ' child category ';
        $msg = '';
        if($has_item_info && $has_child_category_info ){
            $msg = $msg_prefix.$msg_item_info.','.$msg_category_info;
        }
        else{
            if($has_item_info && !($has_child_category_info)){
                $msg = $msg_prefix.$msg_item_info;
            }
            else if($has_child_category_info && !($has_item_info)){
                $msg = $msg_prefix.$msg_category_info;
            }
        }
        $data = [
            'ICDeletedAt' => date("Y-m-d H:i:s"),
            'ICDeletedBy' => $user_info->UserID,
            'delete_flag'=>'1',
        ];
        if($has_item_info || $has_child_category_info ){
            return $this->response->setJSON([
                'error' => true,
                'message' => $msg
            ]);
        }
        else{
            $this->itemCategoryInformationModel->deleteData($id, $data);
            return $this->response->setJSON([
                'error' => false,
                'message' => 'Successfully deleted!'
            ]);
        }
    }

    // check level no and generate
    public function checkLevel($id)
    {
        $preData = json_decode(json_encode($this->ItemCategoryModel->getSingleICData($id)), true);
        $iclevelno = $preData['ICLevel'];
        // var_dump($iclevelno);
        // exit();
        // Extract the numeric portion of the previous baton number
        $previousLevelNumberNumeric = (int)$iclevelno;

        // Increment the numeric portion
        $newLevelNumberNumeric = $previousLevelNumberNumeric + 1;

        // Format the new baton number
        $newLevelNumber = sprintf('%01d', $newLevelNumberNumeric);
        // var_dump($newLevelNumberNumeric);
        // exit();

        return $newLevelNumber;
    }

     // Item category disable
     public function disableItemCatgory($id = null)
     {
        $data2 = [
            'current_status' => '2'
        ];
         $parent_cat_data=$this->itemCategoryInformationModel->index();
         foreach ($parent_cat_data as $data) {
            $parent_id =$data['ICParentID'];
            $status =$data['current_status'];
            if($parent_id==$id){
                if($status!=='2'){
                    $item_cat_id=$data['ICID'];
                    $data = [
                        'current_status' => '3'
                    ];
                    $this->itemCategoryInformationModel->update_status($item_cat_id,$data);
                }
            }
        }
        if($this->itemCategoryInformationModel->statusupdate($id, $data2)):                
            echo json_encode(array('status'=>true));
        endif;
     }
     // Item category enable
     public function enableItemCatgory($id = null)
     {
         $data2 = [
             'current_status' => '1'
         ];
         $parent_cat_data=$this->itemCategoryInformationModel->index();
         foreach ($parent_cat_data as $data) {
            $parent_id =$data['ICParentID'];
            $status =$data['current_status'];
            if($parent_id==$id){
                if($status=='3'){
                    $item_cat_id=$data['ICID'];
                    $data = [
                        'current_status' => '1'
                    ];
                    $this->itemCategoryInformationModel->update_status($item_cat_id,$data);
                }
               
            }
        }
         if($this->itemCategoryInformationModel->statusupdate($id, $data2)):                
             echo json_encode(array('status'=>true));
         endif;
     }
}