<?php

namespace App\Controllers;
use App\Controllers\BaseController;
use App\Models\DeliveryModel;
use App\Models\EmployeeModel;
use App\Models\SalesModel;
use App\Models\CustomerModel;

class DeliveryController extends BaseController
{
    //construct function
    public function __construct()
    {
        $this->delivery = new DeliveryModel();      
        $this->employee = new EmployeeModel();       
        $this->sale = new SalesModel();       
        $this->customer = new CustomerModel(); 
        $this->db = \Config\Database::connect();   
        helper(['url','form','app']);
    }
    //insert/update data
    public function submit() 
    {
        $session = session();
        $validation = $this->validate([
            'emp_id' => [
                'rules'=>'required|greater_than[0]',
                'errors'=>[
                    'required'=>'Please select employee',
                    'greater_than'=>'Please select employee',
                ],
            ],
            'sale_id' => [
                'rules'=>'required|greater_than[0]',
                'errors'=>[
                    'required'=>'Please select sale ID',
                    'greater_than'=>'Please select sale ID',
                ],
            ],
            'customer_id' => [
                'rules'=>'required|greater_than[0]',
                'errors'=>[
                    'required'=>'Please select customer',
                    'greater_than'=>'Please select customer',
                ],
            ],
            'phone_number' => [
                'rules'=>'required|numeric|max_length[10]',
                'errors'=>[
                    'required'=>'Please enter delivery contact number',
                    'numeric'=>'Please enter a valid phone number',
                    'max_length'=>'Please enter a valid phone number',
                ],
            ],
            'address' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter delivery address',
                ],
            ],
            'estimated_shipping_date' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select estimated shipping date',
                ],
            ],
            'estimated_delivery_date' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter estimated delivery date',
                ],
            ],
            'actual_shipping_date' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter delivery actual shipping date',
                ],
            ],
            'actual_delivery_date' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter actual delivery date',
                ],
            ],
        ]);
        $id = $this->request->getVar('id');
        if($validation){
            if($id == ''){  
                //insert
                $data = [
                    'sale_id'  => $this->request->getVar('sale_id'),
                    'customer_id'  => $this->request->getVar('customer_id'),
                    'emp_id'  => $this->request->getVar('emp_id'),
                    'address'  => $this->request->getVar('address'),
                    'phone_number' => $this->request->getVar('phone_number'),
                    'estimated_shipping_date' => $this->request->getVar('estimated_shipping_date'),
                    'estimated_delivery_date' => $this->request->getVar('estimated_delivery_date'),
                    'actual_shipping_date' => $this->request->getVar('actual_delivery_date'),
                    'actual_delivery_date' => $this->request->getVar('actual_delivery_date'),
                    'created_at' => date('Y-m-d H:i:s'),
                ];
                 //set trans status
                $transaction_status = false;
                //---begin transaction---
                $this->db->transBegin();
                $this->delivery->insertData($data);
                if ($this->db->transStatus() === FALSE){
                    //---rollback transaction
                    $this->db->transRollback();
                    $transaction_status = false;
                       // Set the success flash message
                    $session->setFlashdata('title', 'Error');
                    $session->setFlashdata('icon', 'warning');
                    $session->setFlashdata('message', 'Something Went wrong.');  
                }
                else{
                    //---commit transaction
                    $this->db->transCommit();
                    $transaction_status = true;
                   // Set the success flash message
                    $session->setFlashdata('title', 'Saved');
                    $session->setFlashdata('icon', 'success');
                    $session->setFlashdata('message', 'Delivery details saved successfully.'); 
                }     
            }
            else{   
                //update
                $data = [
                    'id' => $this->request->getVar('id'),
                    'sale_id'  => $this->request->getVar('sale_id'),
                    'customer_id'  => $this->request->getVar('customer_id'),
                    'emp_id'  => $this->request->getVar('emp_id'),
                    'address'  => $this->request->getVar('address'),
                    'phone_number' => $this->request->getVar('phone_number'),
                    'estimated_shipping_date' => $this->request->getVar('estimated_shipping_date'),
                    'estimated_delivery_date' => $this->request->getVar('estimated_delivery_date'),
                    'actual_shipping_date' => $this->request->getVar('actual_delivery_date'),
                    'actual_delivery_date' => $this->request->getVar('actual_delivery_date'),
                    'updated_at' => date('Y-m-d H:i:s'),
                ];
                $this->delivery->updateData($id, $data);
            }
            return $this->response->redirect(site_url('/delivery'));
        }
        else{
            $user_info = getUserInfo();
            $records['Delivery'] = $this->delivery->index();
            $employees = $this->employee->getIndexData();
            $sales = $this->sale->index();
            $customers = $this->customer->index();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Delivery',
                'link' => 'delivery',
                'sources' => $records,
                'userinfo' => $user_info,
                'employees' => $employees,
                'sales' => $sales,
                'customers' => $customers,
                'has_errors' => $has_errors,
                'validation'=>$this->validator,
            );
            return view('delivery', $data);
        }
    }
    //get specific data
    public function getSpecificData($id = null) 
    {
        $data=$this->delivery->getSpecificData($id);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }
    //get all data
    public function index()
    {
        $user_info = getUserInfo();
        $records['Delivery'] = $this->delivery->index();
        $employees = $this->employee->getIndexData();
        $sales = $this->sale->index();
        $customers = $this->customer->index();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Delivery',
            'link' => 'delivery',
            'sources' => $records,
            'userinfo' => $user_info,
            'employees' => $employees,
            'sales' => $sales,
            'customers' => $customers,
            'has_errors' => $has_errors,
        );
        return view('delivery', $data);
    }
    // delete data
    public function delete($id = null)
    {
        $session = session();
        $now = date("Y-m-d H:i:s");
        $data = [
            'deleted_at' => $now,
            'delete_flag' => 1,
        ];
        $this->delivery->deleteData($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    } 

       // delivery disable
    public function disabledelivery($id = null)
    {
           $data = [
               'current_status' => '2'
           ];
           if($this->delivery->statusupdate($id, $data)):                
               echo json_encode(array('status'=>true));
           endif;
    }
       // delivery enable
    public function enabledelivery($id = null)
     {
           $data = [
               'current_status' => '1'
           ];
           if($this->delivery->statusupdate($id, $data)):                
               echo json_encode(array('status'=>true));
           endif;
     }
}
