<?php

namespace App\Controllers;
use App\Models\BanksModel;
use App\Models\UserModel;
use App\Controllers\BaseController;
use App\Models\CommonModel;

class BanksController extends BaseController
{    
    public function __construct()
    {
        $this->UserModel = new UserModel();
        $this->bankModel = new BanksModel();
        $this->common = new CommonModel();    
        $this->now = date("Y-m-d H:i:s");
        $this->db = \Config\Database::connect();
        helper(['url','form','app']);
    }
    // insert data
    public function insert() 
    {
        $validation = $this->validate([
            'BankName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please Enter Item Name',
                ],
            ],
            // 'BCardType' => [
            //     'rules'=>'required',
            //     'errors'=>[
            //         'required'=>'Please select value',
            //     ],
            // ],
            // 'BRate' => [
            //     'rules'=>'required',
            //     'errors'=>[
            //         'required'=>'Please enter value',
            //     ],
                
            // ],
            // 'BStartingDate' => [
            //     'rules'=>'required',
            //     'errors'=>[
            //         'required'=>'Please select date',
            //     ],
                
            // ],
            // 'BEndingDate' => [
            //     'rules'=>'required',
            //     'errors'=>[
            //         'required'=>'Please select date',
            //     ],
            // ],

        ]);
        $bID = $this->request->getVar('BID');
        $user_info = getUserInfo();     
        $session = session();
        if($validation){

            if($bID == ''){  //insert bank details
        $data = [
            'BankName' => $this->request->getVar('BankName'),
            // 'BCardType'  => $this->request->getVar('BCardType'),
            // 'BRate'  => $this->request->getVar('BRate'),
            // 'BStartingDate'  => $this->request->getVar('BStartingDate'),
            // 'BEndingDate'  => $this->request->getVar('BEndingDate'),
            'delete_flag' => '0',
            'BCreatedat' => date('Y-m-d H:i:s'),
            'BCreatedBy' => $user_info->UserID,
        ];

          //set trans status
          $transaction_status = false;
          //---begin transaction---
          $this->db->transBegin();
        $this->bankModel->insertBankData($data);
        if ($this->db->transStatus() === FALSE){
            //---rollback transaction
            $this->db->transRollback();
            $transaction_status = false;
               // Set the success flash message
            $session->setFlashdata('title', 'Error');
            $session->setFlashdata('icon', 'warning');
            $session->setFlashdata('message', 'Something Went wrong.');  
        }
        else{
            //---commit transaction
            $this->db->transCommit();
            $transaction_status = true;
           // Set the success flash message
            $session->setFlashdata('title', 'Saved');
            $session->setFlashdata('icon', 'success');
            $session->setFlashdata('message', 'Bank details saved successfully.'); 
        }     
        }
        else{   //update bank details
            $data = [
                'BankName' => $this->request->getVar('BankName'),
                // 'BCardType'  => $this->request->getVar('BCardType'),
                // 'BRate'  => $this->request->getVar('BRate'),
                // 'BStartingDate'  => $this->request->getVar('BStartingDate'),
                // 'BEndingDate'  => $this->request->getVar('BEndingDate'),
                'BUpdatedAt'=>date('Y-m-d H:i:s'),
                'BUpdatedBy' => $user_info->UserID,
            ];
            $this->bankModel->updateBank($bID, $data);
            // Set the success flash message
            $session->setFlashdata('title', 'Saved');
            $session->setFlashdata('message', 'Bank details updated successfully.');
        }
        return $this->response->redirect(site_url('/banks'));
        }
     else{
        $user_info = getUserInfo();      
        $bms['Banks']=$this->bankModel->getIndexNBankData();
        $has_errors = 'true';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Banks',
            'link' => 'banks',
            'sources' => $bms,
            'userinfo' => $user_info,
            'validation'=>$this->validator,
            'has_errors' => $has_errors,
        );
        return view('banks', $data);
      }
    }
   
    //get single data
    public function singleData($id = null)
     {
        $data=$this->bankModel->getSingleBankData($id);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    public function index()
    {
        $user_info = getUserInfo();
        $bms['Banks']=$this->bankModel->getIndexNBankData();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Banks',
            'link' => 'banks',
            'sources' => $bms,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        return view('banks', $data);
    }
    
    // delete
    public function delete($id = null)
    {
        $user_info = getUserInfo(); 
        $has_price_rule_info = $this->common->checkForeignKeyConstraints("price_rules","pr_bank",$id,"pr_status",1);
        $has_payment_info = $this->common->checkForeignKeyConstraints("payments","bank_id",$id,"delete_flag",0);
        // $has_card_promotion_info = $this->common->checkForeignKeyConstraints("card_promotion","bank_name",$id,"delete_flag",0);
         //define message
         $msg_prefix = 'This bank has ';
         $msg_price_rule_info = 'price rule information';
         $msg_payment_info = ' payment information ';
         $msg = '';
         if($has_user_info && $has_rulebook_info ){
             $msg = $msg_prefix.$msg_user_info.','.$msg_rulebook_info;
         }
         else{
             if($has_price_rule_info && !($msg_payment_info)){
                 $msg = $msg_prefix.$msg_price_rule_info;
             }
             else if($has_payment_info && !($msg_price_rule_info)){
                 $msg = $msg_prefix.$msg_payment_info;
             }
         }
        $data = [
            'BDeletedAt' =>  $this->now,
            'BDeletedBy'=>$user_info->UserID,
            'delete_flag' => '1',
        ];
        if($has_price_rule_info || $has_payment_info ){
        //    if($has_price_rule_info ){
            return $this->response->setJSON([
                'error' => true,
                'message' => $msg
            ]);
        }
        else{
            $this->bankModel->deleteBank($id, $data);
            return $this->response->setJSON([
                'error' => false,
                'message' => 'Successfully deleted!'
            ]);
        }
      
        return $this->response->redirect(site_url('/banks'));
    } 
      // bank disable
      public function disablebank($id = null)
      {
          $data = [
              'current_status' => '2'
          ];
          if($this->bankModel->statusupdate($id, $data)):                
              echo json_encode(array('status'=>true));
          endif;
      }
      //bank enable
      public function enablebank($id = null)
      {
          $data = [
              'current_status' => '1'
          ];
          if($this->bankModel->statusupdate($id, $data)):                
              echo json_encode(array('status'=>true));
          endif;
      }
}
