<?php

    namespace App\Controllers\Api;

    use CodeIgniter\RESTful\ResourceController;
    use CodeIgniter\API\ResponseTrait;
    use App\Models\UserModel;

    class User extends ResourceController
    {
        use ResponseTrait;

        public function index()
        {
            $UserModel = new UserModel();
            $Users['Users'] = $UserModel->orderBy('UserID', 'DESC')->findAll();
            return $this->respond($Users);
        }
        // create user
        public function create() {
            $model = new UserModel();
            $data = [
                'EmpID' => $this->request->getPost('EmpID'),
                'UserRole' => $this->request->getPost('UserRole'),
                'UserName' => $this->request->getPost('UserName'),
                'UserPassword' => md5($this->request->getPost('UserPassword')),
                'UserStatus' => $this->request->getPost('UserStatus')
            ];
            $model->insert($data);
            $response = [
                'status'   => 201,
                'error'    => null,
                'messages' => [
                    'success' => 'User created successfully'
                ]
            ];
            return $this->respondCreated($response);
        }
        // single user
        public function show($id = null){
            $model = new UserModel();
            $data = $model->where('UserID', $id)->first();
            if($data){
                return $this->respond($data);
            }else{
                return $this->failNotFound('No User found');
            }
        }        
        // update
        public function update($id = null){
            $model = new UserModel();
            $id = $this->request->getVar('id');
            $data = [
                'username' => $this->request->getVar('username'),
                'password' => md5($this->request->getVar('password'))
            ];
            $model->update($id, $data);
            $response = [
                'status'   => 200,
                'error'    => null,
                'messages' => [
                    'success' => 'User updated successfully'
                ]
            ];
            return $this->respond($response);
        }
        // delete
        public function delete($id = null){
            $model = new UserModel();
            $data = $model->where('UserID', $id)->delete($id);
            if($data){
                $model->delete($id);
                $response = [
                    'status'   => 200,
                    'error'    => null,
                    'messages' => [
                        'success' => 'User successfully deleted'
                    ]
                ];
                return $this->respondDeleted($response);
            }else{
                return $this->failNotFound('No User found');
            }
        }
    }

?>