<?php

    namespace App\Controllers\Api;

    use CodeIgniter\RESTful\ResourceController;
    use CodeIgniter\API\ResponseTrait;
    use App\Models\SalesModel;

    class Sales extends ResourceController
    {
        use ResponseTrait;

        public function index(){            
            $SalesModel = new SalesModel();
            $sales['sales'] = $SalesModel->orderBy('sale_id', 'DESC')->findAll();
            return $this->respond($sales);
        }
        // create sales
        public function create() {
            $model = new SalesModel();
            $data = [
                'sale_time' => date('m/d/Y h:i:s a'),
                'customer_id' => $this->request->getPost('customer_id'),
                'employee_id' => $this->request->getPost('employee_id'),
                'comment' => $this->request->getPost('comment'),
                'payment_type' => $this->request->getPost('payment_type'),
                'sale_discount' => $this->request->getPost('sale_discount')
            ];
            $model->insert($data);
            $response = [
                'status'   => 201,
                'error'    => null,
                'messages' => [
                    'success' => 'Sales created successfully'
                ]
            ];
            return $this->respondCreated($response);
        }
        // single sale
        public function show($id = null){
            $model = new SalesModel();
            $data = $model->where('sale_id', $id)->first();
            if($data){
                return $this->respond($data);
            }else{
                return $this->failNotFound('No Sale found');
            }
        }
    }
?>