<?php $this->extend('layouts/master') ?>

<?php $this->section('sales') ?>
<style>
   input::-webkit-outer-spin-button,
    input::-webkit-inner-spin-button {
    -webkit-appearance: none;
    margin: 0;
    }
</style>

        <!--- Sale Status --->
        <div class="container-fluid mt-3">
            <div class="row">
                <div class="col-8">
                    <div class="row">
                        <div class="col-4 ps-0">
                            <!-- <div class="d-flex bd-highlight bg-third text-secondary py-1 Bardcode-scn">
                                <div class="p-2 flex-fill bd-highlight fw-bold">Scan Bardcode</div>
                                <div class="flex-fill bd-highlight csn-btn btn linear-bg"><img class="mt-1" src="./assets/images/icons/scanner1.svg">
                                </div>
                            </div> -->
                        </div>
                        <div class="col-12 pe-0">
                            <div class="d-flex bd-highlight bg-third text-secondary py-1 customer-select ps-1">
                                <div class="pt-2 ps-2 flex-fill bd-highlight fw-bold">Customer ID: 
                                    <input type="text" id="customer_id" name="customer_id" class="customer_id" readonly required>
                                </div>
                                <div class="pt-2 ps-2 flex-fill bd-highlight fw-bold">Customer Phone Number: 
                                    <input type="text" id="customer_phone_number" name="customer_phone_number" class="customer_phone_number">
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <a href="/gift_voucher_sale" class="text-secondary text-decoration-none">    
                                                        Gift Voucher Sale
                                                    </a>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 me-3 ms-1 bill-area">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">Sale Type</div>
                                            <div class="flex-fill bd-highlight">
                                                <select class="form-select ms-2 py-0 text-primary fw-bold"
                                                    aria-label="Default select example" id="sale_type" name="sale_type">
                                                    <option value="0" disable>---Select Sale Type---</option>
                                                    <option value="1" selected>Cash</option>
                                                    <option value="2">Credit</option>
                                                </select>
                                                <input type="text" hidden id="payment_authorized_by_id" name="payment_authorized_by_id">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                        <div class="flex-fill bd-highlight">Find Item </div>
                                        <div class="flex-fill bd-highlight">                                      
                                            <select id="item_searchable_drop_down" class="form-select ms-2 py-0 text-primary fw-bold" aria-label="Default select example">
                                                <option value="0" selected disabled>Start Typing item's name</option>                                               
                                                <?php
                                                    if ($sources):
                                                    foreach ($sources as $source):
                                                ?>
                                                        <option value="<?php echo $source['ItemID']; ?>"><?php echo $source['ItemID']; ?>-<?php echo $source['ItemName']; ?></option>
                                                <?php
                                                   endforeach;
                                               endif;
                                               ?>
                                            </select>
                                        </div>
                                        <div class="ps-4 py-0 text-primary fw-bold">
                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#userdteModal">
                                                <i class="bi bi-upc-scan"></i>
                                            </button>
                                        </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">Scan Item</div>
                                            <div class="flex-fill bd-highlight">
                                                <input type="text" id="item_id" name="item_id">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">Currency</div>
                                            <div class="flex-fill bd-highlight">
                                                <select class="form-select ms-2 py-0 text-primary fw-bold"
                                                    aria-label="Default select example">
                                                    <option selected>LKR</option>
                                                    <option value="1">AUS</option>
                                                    <option value="2">IDR</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div> -->
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table" id="sale_tbl_div">
                                <div class="tableFixHead mt-2">
                                <div class="mb-2">
                                    <button type="button" class="delete-row btn linear-bg text-secondary px-2 py-0">Delete Row(s)</button>
                                    <input type="text" id="deleted_item_ids" name="deleted_item_ids" hidden>
                                </div>
                                    <div class="modal" id="serial_data_modal" data-bs-backdrop="static" data-bs-keyboard="false">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                        <div class="modal-header">
                                            <div class="row">
                                                <p>Item:<span id="modalRow"></span></p>
                                                <p hidden><span id="tbl_row_id"></span></p>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <h5 class="modal-title" style="text-align: center;">Serial Number</h5>
                                                </div>
                                                <div class="col-md-4">
                                                    <h5 class="modal-title" style="text-align: center;">Warranty Period</h5>
                                                </div>
                                                <div class="col-md-4" style="text-align: right;">
                                                    <button class="btn linear-bg text-secondary add-input-row">+ Serial Data</button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-body">
                                            <div class="input-fields">
                                            <div class="row"  style="margin-top:5px;margin-bottom:5px;">
                                                <div class="form-group col-md-5">
                                                    <input type="text" class="form-control">
                                                </div>
                                                <div class="form-group col-md-5">
                                                    <input type="text" class="form-control">
                                                </div>
                                                <div class="form-group col-md-2">
                                                    <button type="button" class="delete-input-row btn linear-bg text-secondary deleteRow"><i class="bi bi bi-trash3-fill"></i></button>
                                                </div>
                                            </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button class="btn linear-bg text-secondary save">Save</button>
                                            <button class="btn btn-secondary close" data-dismiss="modal">Close</button>
                                        </div>
                                        </div>
                                    </div>
                                    </div>        


                                    <table class="table rounded align-middle" id="sale_item_data_table" name="sale_item_data_table">
                                        <thead class="text-center text-secondary rounded">
                                            <th scope="col">Item#</th>
                                            <th scope="col">Item Name</th>
                                            <th scope="col">Disc %</th>
                                            <th scope="col">Price</th>
                                            <th scope="col">Qty on hand</th>
                                            <th scope="col">Qty</th>
                                            <th scope="col">Total</th>
                                            <th class="rounded-end" colspan="4">Action</th>
                                        </thead>
                                        <tbody class="text-primary fw-bold">
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-4">
                    <div class="linear-bg rounded-15 p-2">
                        <div class="bill-box rounded-15 bg-secondary p-1">
                            <table class="table table-borderless my-0">
                                <tbody class="text-primary fw-bold ">
                                    <tr>
                                        <td class="py-0">Bill total without Item wise discount</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"><input readonly type="text" id="bill_total_sum" name="bill_total_sum"></input></td>
                                    </tr>
                                    <tr>
                                        <td class="py-0">Total Item wise Discount</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"><input readonly type="text" id="total_item_wise_discount_amount" name="total_item_wise_discount_amount"> </input> </td>
                                    </tr>
                                    <tr>
                                        <td class="py-0">Sub Total</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"><input readonly type="text" id="sub_total" name="sub_total"></input></td>
                                    </tr>
                                    <tr>
                                        <td class="py-0">Tax</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0" id="tax" name="tax"  style="text-align:center;"><?php echo $tax; ?></td>
                                    </tr>
                                    <tr>
                                        <td class="py-0">Total with Tax</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"><input type="text" id="total_with_tax" name="total_with_tax" readonly></td>
                                    </tr>
                                    <tr>
                                        <td class="py-0">Total Bill Discount</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"><input  type="number" id="total_bill_discount_amount" name="total_bill_discount_amount" value="0" style="text-align:center;width:100%;"> </input> </td>
                                    </tr>
                                    <tr>
                                        <td class="py-0">Net Total</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"><input readonly type="text" id="net_total" name="net_total"></td>
                                    </tr>
                                    <tr id="loyalty_percentage_tr">
                                        <td class="py-0" colspan="2">Loyalty Percentage</td>
                                        <td class="py-0" id="loyalty_percentage" name="loyalty_percentage"  style="text-align:center;"><?php echo $loyalty_percentage; ?>%</td>
                                    </tr>
                                    <tr id="total_loyalty_points_for_this_bill_tr">
                                        <td class="py-0" colspan="2">Total Loyalty Points Earned for this Bill</td>
                                        <td class="py-0"><input readonly type="text" id="total_loyalty_points_for_this_bill" name="total_loyalty_points_for_this_bill" value="0"></td>
                                    </tr>
                                    <tr id="balace_cash_to_loyalty_tr">
                                        <td class="py-0">Add Balace Cash Amount to Loyalty</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"><input type="number" id="balace_cash_to_loyalty" name="balace_cash_to_loyalty" value="0" style="text-align:center;width:100%;"></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="bill-box rounded-15 bg-secondary p-1 my-2">
                            <table class="table table-borderless my-0">
                                <tbody class="text-primary fw-bold ">
                                    <tr>
                                        <td class="py-0">Payment Total</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"><input type="text" readonly id="payment_total" name="payment_total"></td>
                                    </tr>
                                    <tr>
                                        <td class="py-0">Amount Due</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"><input type="text" readonly id="amount_due" name="amount_due"></td>
                                    </tr>
                                    <tr>
                                        <td class="py-0">Amount Deduct</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="bill-box rounded-15 bg-secondary p-1" id="payment_data_tbl_div" name="payment_data_tbl_div">
                            
                        </div>
                    </div>
                    <div class="container bill-option-btn-set mt-2 py-2">
                        <!-- <div class="row">
                            <div class="col p-0 icon-btn">
                                <div
                                    class="menu-item col text-center rounded linear-bg mx-1 ms-1 p-1 align-self-center text-secondary py-2">
                                    <a>
                                        <img src="./assets/images/icons/cash-coin.svg" alt="home"
                                            class="white-img mt-1">
                                    </a>
                                </div>
                            </div>
                            <div class="col p-0 icon-btn">
                                <div
                                    class="menu-item col text-center rounded linear-bg mx-1 ms-1 p-1 align-self-center text-secondary py-2">
                                    <a>
                                        <img src="./assets/images/icons/credit-card.svg" alt="home"
                                            class="white-img mt-1">
                                    </a>
                                </div>
                            </div>
                            <div class="col p-0 icon-btn">
                                <div
                                    class="menu-item col text-center rounded linear-bg mx-1 ms-1 p-1 align-self-center text-secondary py-2">
                                    <a>
                                        <img src="./assets/images/icons/qr-code-scan.svg" alt="home"
                                            class="white-img mt-1">
                                    </a>
                                </div>
                            </div>
                        </div> -->
                        <div class="row mt-2">
                            <div class="col p-0" id="add_payment_btn" name="add_payment_btn" style="cursor:pointer">
                                <div
                                    class="menu-item col text-center rounded linear-bg mx-1 ms-1 p-1 align-self-center text-secondary">
                                    <a>
                                        <img src="./assets/images/icons/plus-lg.svg" alt="home" class="white-img mt-1">
                                        <div class="menu-item-name">Add Payment</div>
                                    </a>
                                </div>
                            </div>
                            <div class="col p-0" id="edit_payment_btn" name="edit_payment_btn" style="cursor:pointer;display:none;">
                                <div
                                    class="menu-item col text-center rounded linear-bg mx-1 ms-1 p-1 align-self-center text-secondary">
                                    <a>
                                        <img src="./assets/images/icons/plus-lg.svg" alt="home" class="white-img mt-1">
                                        <div class="menu-item-name">Edit Payment</div>
                                    </a>
                                </div>
                            </div>
                            <!-- <div class="col p-0">
                                <div
                                    class="menu-item col text-center rounded linear-bg mx-1 ms-1 p-1 align-self-center text-secondary">
                                    <a>
                                        <img src="./assets/images/icons/percent.svg" alt="home" class="white-img mt-1">
                                        <div class="menu-item-name">Discount</div>
                                    </a>
                                </div>
                            </div> -->
                            <div class="col p-0">
                                <div id="end_sale_btn" name="end_sale_btn" style="cursor:pointer !important"
                                    class="menu-item col text-center rounded linear-bg mx-1 ms-1 p-1 align-self-center text-secondary">
                                    <a id="end_sale" name="end_sale">
                                        <img src="./assets/images/icons/forward.svg" alt="home" class="white-img mt-1">
                                        <div class="menu-item-name">End Sale</div>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- Sale Status End --->
        <!--Multiple selling price selection modal: start-->
        <div class="modal fade" id="submit_modal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Multiple selling price selection</h5>
                        <button id="close_modal" type="button" class="btn-close bg-secondary" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3 col">
                            <label for="" class="col-form-label">Select Selling Price:</label>
                            <div id="multiple_selling_price_list" name="multiple_selling_price_list">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--Multiple selling price selection modal: end-->
        <!--Item serial data enter modal: start-->
        <div class="modal fade" id="serial_data_enter_modal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Enter Item Serial Data</h5>
                        <button id="close_serial_modal" type="button" class="btn-close bg-secondary" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body" id="serial_data_enter_modal_body">
                        <div class="row" id="initial_serial_div" name="initial_serial_div">          
                            <input hidden type="text" class="serial_item_id" id="serial_item_id" name="serial_item_id">                      
                            <div class="mb-3 col">
                                <label for="" class="col-form-label">Serial Number:</label>
                                <input type="text" class="serial_number" id="serial_number" name="serial_number">
                            </div>
                            <div class="mb-3 col">
                                <label for="" class="col-form-label">Warranty Period:</label>
                                <input type="text" class="warranty_period1" id="warranty_period" name="warranty_period">
                            </div>
                        </div>    
                        <div class="row" id="additional_serial_div" name="additional_serial_div">

                        </div>  
                        <div class="mb-3 col">
                                <button type="button" class="btn linear-bg text-secondary" id="add_another_serial_btn" name="add_another_serial_btn"><i class="bi bi-plus-lg fw-bold"></i></button>
                        </div>      
                    </div>
                </div>
            </div>
        </div>
        <!--Item serial data enter modal: end-->
        <!--Payment data enter modal: start-->
        <div class="modal fade" id="payment_data_enter_modal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <input type="text" id="keep_payment_modal_open" name="keep_payment_modal_open" hidden>
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Enter Payment Data</h5>
                        <button id="close_payment_data_modal" type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body" id="payment_data_enter_modal_body">
                        <div class="row">
                            <div class="mb-3 col">
                                <label for="toal">Total:</label>
                                <input type="text" id="total" name="total" readonly style="width:20%;"><span style="color:white;">A</span>
                                <label for="due">Due:</label>
                                <input type="text" id="due" name="due" readonly style="width:20%;"><span style="color:white;">A</span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="radio" id="full" name="payment" value="full" checked>
                                <label for="full">Full Payment</label><span style="color:white;">AAAA</span>
                                <input type="radio" id="partial" name="payment" value="partial">
                                <label for="partial">Partial Payment</label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <label for="payment_type" class="col-form-label">Payment Type:</label>
                                <select class="form-control" name="payment_type" id="payment_type" >
                                    <option value="" selected disabled>--Select Payment Type--</option>
                                    <option value="1">Cash</option>
                                    <option value="2">Credit card</option>
                                    <option value="3">Debit card</option>
                                    <option value="4">Cheque</option>
                                    <option value="5">Gift voucher</option>
                                    <!-- <option value="6">Loyality card</option> -->
                                </select>
                            </div>
                            <div class="mb-3 col">
                                <label for="payment_amount" class="col-form-label">Amount:</label>
                                <input type="number" class="" id="payment_amount" name="payment_amount">
                            </div>
                        </div>
                        <div class="row" id="bank_div" name="bank_div" style="display:none;">
                            <div class="mb-3 col">
                                <label id="bank_lbl" for="bank" class="col-form-label">Bank:</label>
                                <select class="form-control" name="bank" id="bank" >
                                    <option value="" selected disabled>--Select Bank--</option>
                                    <?php foreach($banks as $bank){?>
                                        <option value="<?php echo $bank['BID'] ;?>" <?php echo set_select('bank',$bank['BID']);?>><?php echo $bank['BankName'];?></option>"
                                    <?php }?>
                                </select>
                            </div>
                        </div>
                        <div class="row" id="cheque_div" name="cheque_div" style="display:none;">
                            <div class="mb-3 col">
                                <label id="cheque_no_lbl" for="cheque_no" class="col-form-label">Cheque No:</label>
                                <input type="text" class="" id="cheque_no" name="cheque_no">
                            </div>
                        </div>
                        <div class="row" id="card_no_div" name="card_no_div" style="display:none;">
                            <div class="mb-3 col">
                                <label id="card_no_lbl" for="card_no" class="col-form-label">Card No:</label>
                                <input type="text" class="" id="card_no" name="card_no">
                            </div>
                        </div>
                        <div class="row" id="payment_method_div" name="payment_method_div" style="display:none;">
                            <div class="mb-3 col">
                                <input type="text" class="" id="payment_method" name="payment_method" hidden>
                                <label id="payment_method_lbl" for="payment_method" class="col-form-label">Payment Method:</label><br><span style="color:white;">AAA</span>
                                <img src="<?= $visa_logo ?>" alt="" id="payment_method_visa" name="payment_method_visa" style="width:50px;cursor:pointer;padding:1px;"><span style="color:white;">AAA</span>
                                <img src="<?= $master_logo ?>" alt="" id="payment_method_master" name="payment_method_master" style="width:50px;cursor:pointer;padding:1px;"><span style="color:white;">AAA</span>
                                <img src="<?= $amex_logo ?>" alt="" id="payment_method_amex" name="payment_method_amex" style="width:50px;cursor:pointer;padding:1px;"><span style="color:white;">AAA</span>
                                <img src="<?= $cash_cheque_logo ?>" alt="" id="payment_method_cash_cheque" name="payment_method_cash_cheque" style="width:50px;cursor:pointer;padding:1px;"><span style="color:white;">AAA</span>
                                <img src="<?= $account_pay_logo ?>" alt="" id="payment_method_account_pay" name="payment_method_account_pay" style="width:50px;cursor:pointer;padding:1px;"><span style="color:white;">AAA</span>
                            </div>
                        </div>
                        <div class="row" id="exp_date_div" name="exp_date_div"  style="display:none;">
                            <div class="mb-3 col">
                                <label id="exp_date_lbl" for="exp_date" class="col-form-label">Exp Date:</label>
                                <input type="date" class="form-control" name="exp_date" id="exp_date">
                            </div>
                        </div> 
                        <div class="row" id="gift_voucher_div" name="gift_voucher_div" style="display:none;">
                            <div class="mb-3 col">
                                <label id="gift_voucher_lbl" for="gift_voucher" class="col-form-label">Gift Voucher No:</label>
                                <input type="text" class="" id="gift_voucher" name="gift_voucher">
                            </div>
                        </div>
                        <div class="row" id="loyality_div" name="loyality_div" style="display:none;">
                            <div class="mb-3 col">
                                <label id="loyality_lbl" for="loyality_no" class="col-form-label">Loyality No:</label><span style="color:white">XX</span>
                                <button class="btn linear-bg text-secondary px-2 py-0" id="send_loyalty_redeem_otp" name="send_loyalty_redeem_otp" data-toggle="tooltip" data-placement="top" title="Send OTP"><i class="bi bi-chat-square-dots"></i></button>
                                <input type="text" class="" id="loyality_phone_no" name="loyality_phone_no" readonly style="text-align:left !important;">
                                <input type="text" class="" id="loyality_no" name="loyality_no" hidden>
                            </div>
                            <div class="mb-3 col">
                                <label id="loyality_lbl" for="loyalty_auth_code" class="col-form-label">Auth Code:</label>
                                <input type="text" class="" id="loyalty_auth_code" name="loyalty_auth_code">
                            </div>
                            <div class="mb-3 col" hidden>
                                <input type="text" class="" id="customer_loyalty_ids" name="customer_loyalty_ids">
                                <input type="text" class="" id="customer_loyalty_amounts" name="customer_loyalty_amounts">
                                <input type="text" class="" id="loyalty_ids_count" name="loyalty_ids_count">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col"  id="entered_payment_data_div" name="entered_payment_data_div"></div> 
                        </div>  
                        <br>
                        <div class="mb-3 col">
                            <button type="button" name="submit_payment_data" id="submit_payment_data" class="btn linear-bg text-secondary">Submit Payment</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php echo view('includes/footer'); ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            enableLoyalty();
            $('[data-toggle="tooltip"]').tooltip();
            $("#customer_id").val('1');
            window.serial_no_data = [];
            window.item_id_key = 'item_id';
            window.serial_number_key = 'serial_number';
            window.warranty_period_key = 'warranty_period';
            window.payment_data_ar = [];
            window.voucher_data_ar = [];
            window.loyalty_data_ar = [];
            window.loyalty_redeem_data_ar = [];
            window.current_due_amount = 0;
            window.selected_record_ids = [];
            serialModal();
        });
        function serialModal(){
            var rowData = {}; // Object to store row data
            // Array to store the entered data in modal
            var modalData = [];
            // Open modal on button click
            $(document).on('click', '.open-modal', function() {
                // Update the modal with the row value
                var row_id = $(this).closest('tr').attr('id');
                $('#tbl_row_id').text(row_id);
                //update modal with item id
                var modal_row = $(this).data('row');
                $('#modalRow').text(modal_row);
                var rowNumber = row_id;//$(this).data('row');
                var modal = $('#serial_data_modal');
                // Retrieve the row data
                var rowValues = rowData[rowNumber] || { inputs: [] };
                // Clear existing input fields
                modal.find('.input-fields').empty();
                // Add input fields dynamically
                for (var i = 0; i < rowValues.inputs.length; i += 2) {
                var inputRow = $('<div class="row input-row " style="margin-top:5px;margin-bottom:5px;">');
                for (var j = 0; j < 2; j++) {
                    var inputValue = rowValues.inputs[i + j] || '';
                    var inputField = $('<div class="input-row form-group col-md-5">')
                    .append($('<input type="text" class="form-control serial_input">').val(inputValue));
                    inputRow.append(inputField);
                }
                var deleteButton = $('<div class="form-group col-md-2">')
                    .append($('<button type="button" class="delete-input-row btn linear-bg text-secondary deleteRow"><i class="bi bi bi-trash3-fill"></i></button>'));
                inputRow.append(deleteButton);
                modal.find('.input-fields').append(inputRow);
                }
                modal.data('row', rowNumber); // Set the row number in modal data attribute
                modal.modal('show'); // Show the modal
                var button = document.querySelector('.close');
                button.disabled = false;
                setSerialDataClass();
            });
            // Add input row dynamically on "Add Input Row" button click
            $(document).on('click', '.add-input-row', function() {
                var modal_row = $('#modalRow').text();
                var inputRow = $('<div class="row input-row " style="margin-top:5px;margin-bottom:5px;">');
                for (var i = 0; i < 2; i++) {
                var inputField = $('<div class="form-group col-md-5">')
                    .append($('<input type="text" class="form-control serial_input">'));
                inputRow.append(inputField);
                }
                var deleteButton = $('<div class="form-group col-md-2">')
                .append($('<button type="button" class="delete-input-row btn linear-bg text-secondary deleteRow"><i class="bi bi bi-trash3-fill"></i></button>'));
                inputRow.append(deleteButton);
                $('#serial_data_modal .input-fields').append(inputRow);
                //increase qty value
                var sale_data_table_row_id = $('#tbl_row_id').text();
                var current_qty = $("#qty_"+sale_data_table_row_id).val();
                $("#qty_"+sale_data_table_row_id).val(parseInt(current_qty)+1);
                setSerialDataClass();
            });
            // Delete input row on "Delete" button click
            $(document).on('click', '.delete-input-row', function() {
                $(this).closest('.row').remove();
                //decrease qty value
                var sale_data_table_row_id = $('#tbl_row_id').text();
                var current_qty = $("#qty_"+sale_data_table_row_id).val();
                $("#qty_"+sale_data_table_row_id).val(parseInt(current_qty)-1);
                setSerialDataClass();
                if($("#qty_"+sale_data_table_row_id).val() == 0){
                    var button = document.querySelector('.close');
                    button.disabled = false;
                }
            });
            // Save data and close modal on "Save" button click
            $(document).on('click', '.save', function(event) {
                checkDuplicateSerialNumbers();
                var modal = $('#serial_data_modal');
                var rowNumber = $('#tbl_row_id').text();//modal.data('row');
                var inputs = [];
                modal.find('.input-fields .row').each(function() {
                var inputValues = [];
                $(this).find('input').each(function() {
                    inputValues.push($(this).val());
                });
                inputs = inputs.concat(inputValues);
                });
                //check if empty fields
                hasEmptyValue = checkForEmptySerialData();
                // Output the result
                if (hasEmptyValue) {
                    event.preventDefault();
                    Swal.fire({
                        title: 'Serialized Item Data Not Completely Entered',
                        text: 'Please enter all serialized item data',
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'OK',
                        }).then((result) => {
                        if (result.isConfirmed) {
                        } else {
                        }
                    });
                    var button = document.querySelector('.close');
                    button.disabled = true;
                } 
                else{
                    // Store the entered data
                    rowData[rowNumber] = {
                    inputs: inputs
                    };
                    // Store the data in the modalData array
                    modalData.push(rowData);
                    // Perform any desired action with the saved data
                    console.log('Row:', rowNumber);
                    console.log('Inputs:', inputs);
                    //disable qty field
                    // disableQtyField("qty_"+rowNumber);
                    setSerialDataClass();
                    setSerialData();
                    formatSerialData();
                    var has_duplicate_serial_numbers = checkForDuplicateSerialNumberEntries();
                    if(!(has_duplicate_serial_numbers)){
                        modal.modal('hide'); // Hide the modal
                        var class_str = "qty_"+rowNumber;
                        setTotalVal(class_str,2);
                    }
                }
            });
            // Check count and open modal based on input value
            $(document).on('change', '.qty', function(event) {
                // Update the modal with the row value
                var row_id = $(this).closest('tr').attr('id');
                var previousValue = $("#qty_"+row_id).previousValue || '';
                var currentValue = event.target.value;
                // Update the previousValue for the next change event
                $("#qty_"+row_id).previousValue = currentValue;
                var serial_modal_type = 1;
                if(previousValue != 0)
                    openSerialPopup(row_id,this,serial_modal_type,modalData);
            });
            // Close modal on "Close" button click
            closeSerialPopup();
        }
        //set IDs
        function setIDs(){
            //set ids
            $('input[class=is_serialized_txt]').each(function(index, el) {
                $(this).attr('id',"is_serialized_txt_"+(index+1));
            });
            $('input[class=item_id]').each(function(index, el) {
                $(this).attr('id',"item_id_"+(index+1));
            });
            $('input[class=qty]').each(function(index, el) {
                $(this).attr('id',"qty_"+(index+1));
            });
            $('input[class=total]').each(function(index, el) {
                $(this).attr('id',"total_"+(index+1));
            });
            $('input[name=sale_price_value]').each(function(index, el) {
                $(this).attr('id',"sale_price_value_"+(index+1));
            });
            $('select[name=discount]').each(function(index, el) {
                $(this).attr('id',"discount_"+(index+1));
            });
            $('input[class=batch_no]').each(function(index, el) {
                $(this).attr('id',"batch_no_"+(index+1));
            });
            $('button[name=serialize_icon]').each(function(index, el) {
                $(this).attr('id',"serialize_icon_"+(index+1));
            });
            $('input[name=qty_on_hand]').each(function(index, el) {
                $(this).attr('id',"qty_on_hand_"+(index+1));
            });
            $('div[name=delete_icon]').each(function(index, el) {
                $(this).attr('id',"delete_icon_"+(index+1));
            });
            $('div[name=edit_icon]').each(function(index, el) {
                $(this).attr('id',"edit_icon_"+(index+1));
            });
            $('input[name=authorized_by]').each(function(index, el) {
                $(this).attr('id',"authorized_by_"+(index+1));
            });
            $('input[name=bill_total]').each(function(index, el) {
                $(this).attr('id',"bill_total_"+(index+1));
            });
            $('input[name=record]').each(function(index, el) {
                $(this).attr('id',"record_"+(index+1));
            });
        }
        //check for empty serial data
        function checkForEmptySerialData(){
            // Select all input fields by class name
            var inputFields = document.querySelectorAll('.serial_input');
            // Check if any input field has an empty value
            var hasEmptyValue = false;
            for (var i = 0; i < inputFields.length; i++) {
                if (inputFields[i].value.trim() === '') {
                    hasEmptyValue = true;
                    break;
                }
            }
            return hasEmptyValue;
        }
        //check for duplicate serial entries
        function checkForDuplicateSerialNumberEntries(){
            var has_duplicate_serial_numbers = false;
            const elements = document.getElementsByClassName('serial_number');
            const uniqueValues = [];
            for (let i = 0; i < elements.length; i++) {
                const value = elements[i].value;
                if (uniqueValues.includes(value)) {
                    has_duplicate_serial_numbers = true;
                    Swal.fire({
                        title: 'There are duplicate serial number entries',
                        text: 'Please recheck',
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'OK',
                        }).then((result) => {
                        if (result.isConfirmed) {
                        } else {
                        }
                    });
                    // console.log('Duplicate value: ', value);
                } else {
                    uniqueValues.push(value);
                }
            }
            return has_duplicate_serial_numbers;
        }
        //retrieve warranty period
        $(document).on('change', '.serial_number', function() {
            var changedInput = $(this);
            var serial_number = parseInt(changedInput.val());
            var warranty_period = changedInput.closest('.input-row').find('.warranty_period');
            $.ajax({
                url: '/get_serialzed_item_warranty_period/'+ serial_number,
                method: 'GET',
                dataType: 'json',
                success: function(response) {
                    console.log(response);
                    if(response.status == true){
                        console.log(warranty_period)
                        warranty_period.val(response.data);
                    }
                    else{
                        swal.fire({
                            title: 'Serial number not found',
                            text: "Please recheck",
                            icon: 'warning',
                            showCancelButton: false,
                            confirmButtonText: 'Ok',
                        }).then((result) => {
                            if (result.isConfirmed) {
                                
                            }
                            else{
                               
                            }
                        });
                    }
                },
                error: function(xhr, status, error) {
                    // console.log(xhr.responseText);
                    swal.fire({
                        title: 'Serial number not found',
                        text: "Please recheck",
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'Ok',
                    }).then((result) => {
                        if (result.isConfirmed) {
                            
                        }
                        else{
                            
                        }
                    });
                }
            });
        });
        //open serial popup
        function openSerialPopup(row_id,ele,serial_modal_type,modalData){
            // Update the previousQty for the next change event
            if(serial_modal_type == 2){
                var modalData = [];
            }
            console.log("serial_modal_type",serial_modal_type);
            console.log("modalData",modalData);
            setIDs();
            if($("#is_serialized_txt_"+row_id).val() == 1){
                $('#tbl_row_id').text(row_id);
                var item_id_val = $("#item_id_"+row_id).val();
                var modal_row = item_id_val;//$(this).data('row');
                $('#modalRow').text(modal_row);
                // console.log(modalData);
                var modal = $('#serial_data_modal');
                var count = parseInt($(ele).val());
                var rowIndex = row_id;
                if (modalData.length > 0) {
                    var serial_data = modalData[0][rowIndex]['inputs'];
                    var modalRowCount = serial_data.length/2;
                    var modal_row = $('#modalRow').text();
                    console.log('*****');
                    console.log(serial_data);
                    console.log('qty',count);
                    console.log('modalRowCount',count);
                    if (count != modalRowCount) {
                        $('#serial_data_modal-body').empty();
                        $('.input-row').remove();
                        var inputRow = $('<div class="row input-row " style="margin-top:5px;margin-bottom:5px;">');
                        //add existing data
                        for (var i = 0; i < serial_data.length; i++) {
                            var inputField = $('<div class="form-group col-md-5" style="margin-top:5px;margin-bottom:5px;">')
                            .append($('<input type="text" class="form-control serial_input" value="' + serial_data[i] + '">'));
                            inputRow.append(inputField);
                            var deleteButton = $('<div class="form-group col-md-2">')
                            .append($('<button type="button" class="delete-input-row btn linear-bg text-secondary deleteRow"><i class="bi bi bi-trash3-fill"></i></button>'));
                            if(i % 2 !== 0)
                                inputRow.append(deleteButton);
                        }
                        if(count > modalRowCount){
                            //add rows for re entered qty
                            var new_row_count = (parseInt(count - modalRowCount)*2);
                            for (var i = 0; i < new_row_count; i++) {
                                var inputField = $('<div class="form-group col-md-5" style="margin-top:5px;margin-bottom:5px;">')
                                .append($('<input type="text" class="form-control serial_input">'));
                                inputRow.append(inputField);
                                var deleteButton = $('<div class="form-group col-md-2">')
                                .append($('<button type="button" class="delete-input-row btn linear-bg text-secondary deleteRow"><i class="bi bi bi-trash3-fill"></i></button>'));
                                if(i % 2 !== 0)
                                    inputRow.append(deleteButton);
                            }
                        }
                        $('#serial_data_modal .input-fields').append(inputRow);
                        modal.modal('show'); 
                        var button = document.querySelector('.close');
                        button.disabled = true;
                    }
                }
                else{
                    var entered_qty = $("#qty_"+row_id).val();
                    // Clear existing input fields
                    modal.find('.input-fields').empty();
                    // Add input fields dynamically
                    for (var i = 0; i < entered_qty; i++) {
                    var inputRow = $('<div class="row input-row " style="margin-top:5px;margin-bottom:5px;">');
                    for (var j = 0; j < 2; j++) {
                        var inputField = $('<div class="input-row form-group col-md-5">')
                        .append($('<input type="text" class="form-control serial_input">').val(''));
                        inputRow.append(inputField);
                    }
                    var deleteButton = $('<div class="form-group col-md-2">')
                        .append($('<button type="button" class="delete-input-row btn linear-bg text-secondary deleteRow"><i class="bi bi bi-trash3-fill"></i></button>'));
                    inputRow.append(deleteButton);
                    modal.find('.input-fields').append(inputRow);
                    }
                    modal.data('row', row_id); // Set the row number in modal data attribute
                    modal.modal('show'); 
                }
                setSerialDataClass();
            }
        }
        // Hide close button for Modal 1
        const serial_data_modal = document.getElementById("serial_data_modal");
        const closeBtn = serial_data_modal.querySelector(".close");
        closeBtn.style.display = "none";
        // Check count and open modal based on input value
        $(document).on('change', '.qty', function() {
            // Update the modal with the row value
            var row_id = $(this).closest('tr').attr('id');
            var serial_modal_type = 2;
            var modalData = [];
            openSerialPopup(row_id,this,serial_modal_type,modalData);
        });
        // Close modal on "Close" button click
        function closeSerialPopup(){
            $(document).on('click', '.close', function() {
                //check if empty fields
                hasEmptyValue = checkForEmptySerialData();
                // Output the result
                if (hasEmptyValue) {
                    event.preventDefault();
                    Swal.fire({
                        title: 'Serialized Item Data Not Completely Entered',
                        text: 'Please enter all serialized item data',
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'OK',
                        }).then((result) => {
                        if (result.isConfirmed) {
                        } else {
                        }
                    });
                    var button = document.querySelector('.close');
                    button.disabled = true;
                } 
                else{
                    var modal = $('#serial_data_modal');
                    modal.modal('hide'); // Hide the modal
                }
            });
        }
        //disable qty field
        function disableQtyField(id){
            document.getElementById(id).disabled = true;
        }

        //show/hide loyalty options
        function enableLoyalty(){
            loyalty_percentage = ($("#loyalty_percentage").text()).replace(/%/g, "");
            if(loyalty_percentage == 0){
                $("#loyalty_percentage_tr").hide();
                $("#balace_cash_to_loyalty_tr").hide();
                $("#total_loyalty_points_for_this_bill_tr").hide();
            }
            else{
                $("#loyalty_percentage_tr").show();
                $("#balace_cash_to_loyalty_tr").show();
                $("#total_loyalty_points_for_this_bill_tr").show();
            }
        }
        //make item dropdown searchable
        $("#item_searchable_drop_down").select2();
        //set selected item id
        $('#item_searchable_drop_down').on('change', function() {
            var selected_item_id = $(this).val();
            //disable selected item
            // $('#item_searchable_drop_down option[value="' + selected_item_id + '"]').prop('disabled', true);
            $("#item_id").val(selected_item_id);
            //trigger enter key press
            $('#item_id').focus();
            var e = $.Event("keypress");
            e.which = '13';
            $("#item_id").trigger(e);
        });
        //customer get set functionalities
        $('#customer_phone_number').on("change",function(event){
            var keycode = (event.keyCode ? event.keyCode : event.which);
            var customer_phone_number = $("#customer_phone_number").val();
            //check if customer registered
            $.ajax({
                url: '/search_customer_by_phone_number/'+ customer_phone_number,
                method: 'GET',
                dataType: 'json',
                success: function(response) {
                    if(response.status == true){
                        $('#customer_id').val(response.data.customer_id);
                        $('#loyality_no').val(response.data.customer_id);
                        $('#loyality_phone_no').val(customer_phone_number);
                        $('#payment_type').append('<option value="6">Loyality card</option>');
                    }
                    else{
                        swal.fire({
                            title: 'Customer not found',
                            text: "Register?",
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonText: 'Yes, Register',
                            cancelButtonText: 'No',
                        }).then((result) => {
                            if (result.isConfirmed) {
                                window.open('/customer', '_blank');
                            }
                            else{
                                $("#customer_id").val('1');
                            }
                        });
                        $('#payment_type option[value="6"]').remove();
                    }
                },
                error: function(xhr, status, error) {
                    console.log(xhr.responseText);
                }
            });
        });
        //sale item data functionalities
        var row_count = 0;
        $('#item_id').keypress(function(event){
            var keycode = (event.keyCode ? event.keyCode : event.which);
            var item_id = $("#item_id").val();
            //capture enter key press
            if(keycode == '13'){
                //get data
                $.ajax({
                    url: 'item_get_item_data/'+item_id,
                    type: "GET",
                    dataType: 'json',
                    success: function (res) {
                        //set data
                        var item_id = '<input type="item_id" name="item_id" class="item_id" readonly style="" value="'+res.data.item_id+'">';
                        var item_name = '<input type="item_name" name="item_name" class="item_name" readonly style="" value="'+res.data.item_name+'">';
                        var item_batch_no = res.data.batch_no;
                        var item_sale_price = res.data.selling_price;
                        var item_qty_on_hand = res.data.qty_on_hand;
                        var delete_icon = '<div name="delete_icon" class="btn-outline-danger text-danger fw-bold h5 text-strock-1" style="" data-toggle="tooltip" data-placement="top" title="Click on checkbox to delete" ><i class="bi bi-x-square"></i></div>';
                        var edit_icon = '<div name="edit_icon" class="btn-outline-success text-success fw-bold h5 text-strock-1" style="cursor:pointer;"><i class="bi bi-pen-fill" data-toggle="tooltip" data-placement="top" title="Edit Qty/Price"></i></div>';
                        var qty = '<input type="number" name="qty" class="qty" value="0" style="width:100%;text-align:center;">';
                        var discount = '<select name="discount" class="discount form-select ms-2 py-0 text-primary fw-bold" aria-label="Default select example"><option selected>0</option><option value="1">10</option><option value="2">25</option></select>';
                        var total = '<input type="number" name="total" class="total" readonly>';
                        var bill_total = '<input type="number" name="bill_total" class="bill_total" readonly>';
                        var edit = '<button class="btn linear-bg text-secondary px-2 py-0" type="button"><i class="bi bi-pen-fill"></i></button>';
                        var selected_selling_price = '';
                        var sale_price = '';
                        var selected_batch_no = '';
                        var batch_no = '';
                        var selected_qty_on_hand = '';
                        var qty_on_hand = '';
                        var authorized_by = '<input hidden type="text" name="authorized_by" class="authorized_by" style="width:70%;">';
                        var is_serialized_txt = '<input hidden type="is_serialized_txt" name="is_serialized_txt" class="is_serialized_txt" readonly style="" value="'+res.data.is_serialized+'">';

                        
                        //check for multiple selling prices
                        if(item_sale_price.length > 1){
                            //populate table
                            $( ".dataTables_empty").remove();
                            for(i=0;i<item_sale_price.length;i++){
                                $('<input type="radio" class="'+item_batch_no[i]+'-'+item_qty_on_hand[i]+'" name="sellingpriceradiobtn" value="'+item_sale_price[i]+'">'+item_sale_price[i]+'</input>').appendTo('#multiple_selling_price_list');
                                $('<input hidden type="text" name="batch_no" value="'+item_batch_no[i]+'"></input>').appendTo('#multiple_selling_price_list');
                                $('<label><span style="color:white;">AAA</span>Qty on hand:</label><span style="color:white;">AAA</span>').appendTo('#multiple_selling_price_list');
                                $('<input readonly style="width:20%;" type="text" name="qty_on_hand" value="'+item_qty_on_hand[i]+'"></input>').appendTo('#multiple_selling_price_list');
                                $("#multiple_selling_price_list").append('<br/><br/>');
                            }
                            $('input[type="radio"][name="sellingpriceradiobtn"]').change(function(e) {
                                var className = $('input[type="radio"][name="sellingpriceradiobtn"]:checked').attr('class');
                                var selected_selling_price_val = e.target.value;
                                var selected_batch_no = className.split('-')[0];
                                var selected_qty_on_hand = className.split('-')[1];
                                console.log(selected_selling_price_val);
                                console.log(selected_batch_no);
                                console.log(selected_qty_on_hand);
                                $("#submit_modal").modal('hide'); 
                                sale_price = selected_selling_price_val;
                                batch_no = selected_batch_no;
                                qty_on_hand = selected_qty_on_hand;
                                $("#multiple_selling_price_list").empty();
                                //check for serialization
                                if(res.data.is_serialized == 1){
                                    // $("#serial_data_enter_modal").modal('toggle'); 
                                    // $("#serial_data_enter_modal").modal('show'); 
                                    $(".serial_item_id").val(res.data.item_id);
                                    $("#sale_item_data_table").append("<tr id="+row_count+"></td><td>" + item_id + "</td><td>" + item_name + "</td><td>" + discount + "</td><td class='' ><input style='width:80%;' readonly class='sale_price_td sale_price_value' name='sale_price_value' value="+ sale_price + "></td><td class=''><input style='width:70%;' readonly class='qty_on_hand' name='qty_on_hand' value="+ qty_on_hand + "></td><td>" + qty + "</td><td>" + total + "</td><td hidden>" + bill_total + "</td><td>" + edit_icon + "</td><td>" + delete_icon + "</td><td><input type='checkbox' name='record'><td><button name='serialize_icon' style='' class='open-modal btn linear-bg text-secondary px-2 py-0' data-row="+ res.data.item_id + "><i class='bi bi-upc-scan'></i></button></td><td class='' hidden><input readonly class='batch_no' name='batch_no' value="+ batch_no + "></td><td>" + authorized_by + "</td><td>" + is_serialized_txt + "</td></tr>");
                                }
                                else{
                                    $("#sale_item_data_table").append("<tr id="+row_count+"></td><td>" + item_id + "</td><td>" + item_name + "</td><td>" + discount + "</td><td class=''><input style='width:80%;' readonly class='sale_price_td sale_price_value' name='sale_price_value' value="+ sale_price + "></td><td class=''><input style='width:70%;' readonly class='qty_on_hand' name='qty_on_hand' value="+ qty_on_hand + "></td><td>" + qty + "</td><td>" + total + "</td><td hidden>" + bill_total + "</td><td>" + edit_icon + "</td><td>" + delete_icon + "</td><td><input type='checkbox' name='record'><td class='' hidden><input readonly class='batch_no' name='batch_no' value="+ batch_no + "></td><td>" + authorized_by + "</td><td>" + is_serialized_txt + "</td></tr>");
                                }
                                setValues();
                            });
                            $("#submit_modal").modal('toggle'); 
                            $("#submit_modal").modal('show'); 
                            $('#close_modal').click(function(event){$("#multiple_selling_price_list").empty();});
                        }
                        else{
                            sale_price = item_sale_price;
                            batch_no = item_batch_no;
                            qty_on_hand = item_qty_on_hand;
                            //populate table
                            $( ".dataTables_empty").remove();
                            //check for serialization
                            if(res.data.is_serialized == 1){
                                // $("#serial_data_enter_modal").modal('toggle'); 
                                // $("#serial_data_enter_modal").modal('show'); 
                                $(".serial_item_id").val(res.data.item_id);
                                $("#sale_item_data_table").append("<tr id="+row_count+"><td>" + item_id + "</td><td>" + item_name + "</td><td>" + discount + "</td><td class='' ><input style='width:80%;' readonly class='sale_price_td sale_price_value' name='sale_price_value' value="+ sale_price + "></td><td class=''><input style='width:70%;' readonly class='qty_on_hand' name='qty_on_hand' value="+ qty_on_hand + "></td><td>" + qty + "</td><td>" + total + "</td><td hidden>" + bill_total + "</td><td>" + edit_icon + "</td><td>" + delete_icon + "</td><td><input type='checkbox' name='record'><td><button name='serialize_icon' style='' class='open-modal btn linear-bg text-secondary px-2 py-0' data-row="+ res.data.item_id + "><i class='bi bi-upc-scan'></i></button></td><td hidden><input readonly class='batch_no' name='batch_no' value="+ batch_no + "></td><td>" + authorized_by + "</td><td>" + is_serialized_txt + "</td></tr>");
                            }
                            else{
                                $("#sale_item_data_table").append("<tr id="+row_count+"><td>" + item_id + "</td><td>" + item_name + "</td><td>" + discount + "</td><td class='' ><input style='width:80%;' readonly class='sale_price_td sale_price_value' name='sale_price_value' value="+ sale_price + "></td><td class=''><input style='width:70%;' readonly class='qty_on_hand' name='qty_on_hand' value="+ qty_on_hand + "></td><td>" + qty + "</td><td>" + total + "</td><td hidden>" + bill_total + "</td><td>" + edit_icon + "</td><td>" + delete_icon + "</td><td><input type='checkbox' name='record'><td hidden><input readonly class='batch_no' name='batch_no' value="+ batch_no + "></td><td>" + authorized_by + "</td><td>" + is_serialized_txt + "</td></tr>");
                            }
                            setValues();
                        }
                        
                        function setValues(){
                            //set IDs
                            setIDs();
                            //set total val
                            $('input[class=qty]').each(function(index, el) {
                                $(this).change(function(event){ 
                                    checkQtyVsCurrentStock(this);
                                    // setTotalVal(this);
                                });
                            });
                            $('select[name=discount]').each(function(index, el) {
                                $(this).change(function(event){
                                    setTotalVal(this,1);
                                });
                            });
                            //enable item edit/delete options
                            $('div[name=edit_icon]').each(function(index, el) {
                                $(this).click(function(event){
                                    var id_str = $(this).attr('id');
                                    var id_no = id_str.split('_')[2];
                                    var qty_id = "#qty_"+id_no;
                                    var sale_price_value_id = "#sale_price_value_"+id_no;
                                    var authorized_by_id = "#authorized_by_"+id_no;
                                    var entered_auth_key;
                                    Swal.fire({
                                        title: 'Enter Auth Key',
                                        input: 'password',
                                        inputAttributes: {
                                            autocapitalize: 'off'
                                        },
                                        showCancelButton: true,
                                        confirmButtonText: 'Authorize',
                                        showLoaderOnConfirm: true,
                                        preConfirm: (auth_key) => {
                                        },
                                        allowOutsideClick: () => !Swal.isLoading()
                                    })
                                    .then((result) => {
                                        if (result.isConfirmed) {
                                            var entered_auth_key = result.value;
                                            //check for authoization
                                            $.ajax({
                                                url: 'user_modify_sale_check_authorization/'+ entered_auth_key,
                                                type: "GET",
                                                data: {
                                                    entered_auth_key: entered_auth_key,
                                                },
                                                success: function(response) {
                                                    console.log(response);
                                                    var is_authorized = response.is_authorized;
                                                    var authorized_by = response.authorized_by;
                                                    if(is_authorized){
                                                        $(qty_id).prop('disabled', false);
                                                        $(sale_price_value_id).prop('readonly', false);
                                                        $(authorized_by_id).val(authorized_by);
                                                    }
                                                    else{
                                                        Swal.fire({
                                                            title: 'Unauthorized!',
                                                            text: 'Invalid Auth Key!',
                                                            icon: 'warning',
                                                            showCancelButton: false,
                                                            confirmButtonText: 'OK',
                                                            }).then((result) => {
                                                            if (result.isConfirmed) {
                                                            } else {
                                                            }
                                                        });
                                                    }
                                                },
                                                error: function(xhr, status, error) {
                                                    console.log(error);
                                                }
                                            });                                            
                                        } else {
                                        }
                                    });
                                });
                            });
                            $('.delete-row').each(function(index, el) {
                                $(this).click(function(event){
                                    var authorized_by_id = "#authorized_by_1";
                                    var entered_auth_key;
                                    Swal.fire({
                                        title: 'Enter Auth Key',
                                        input: 'password',
                                        inputAttributes: {
                                            autocapitalize: 'off'
                                        },
                                        showCancelButton: true,
                                        confirmButtonText: 'Authorize',
                                        showLoaderOnConfirm: true,
                                        preConfirm: (auth_key) => {
                                        },
                                        allowOutsideClick: () => !Swal.isLoading()
                                    })
                                    .then((result) => {
                                        if (result.isConfirmed) {
                                            var entered_auth_key = result.value;
                                            //check for authoization
                                            $.ajax({
                                                url: 'user_modify_sale_check_authorization/'+ entered_auth_key,
                                                type: "GET",
                                                data: {
                                                    entered_auth_key: entered_auth_key,
                                                },
                                                success: function(response) {
                                                    console.log(response);
                                                    var is_authorized = response.is_authorized;
                                                    var authorized_by = response.authorized_by;
                                                    if(is_authorized){
                                                        //delete item row from table and data from arrays
                                                        $("#sale_item_data_table tbody").find('input[name="record"]').each(function(){
                                                            if($(this).is(":checked")){
                                                                $(this).parents("tr").remove();
                                                                selected_record_ids.push(($(this).attr('id')).split('_')[1]);
                                                            }
                                                        });
                                                        // $('#deleted_item_ids').val(selected_record_ids.join(', '));
                                                        // for(el=0;el<selected_record_ids.length;el++){
                                                        //     $('#item_searchable_drop_down option[value="' + selected_record_ids[el] + '"]').prop('disabled', false);
                                                        // }
                                                        setSubTotal();
                                                        $(authorized_by_id).val(authorized_by);
                                                    }
                                                    else{
                                                        Swal.fire({
                                                            title: 'Unauthorized!',
                                                            text: 'Invalid Auth Key!',
                                                            icon: 'warning',
                                                            showCancelButton: false,
                                                            confirmButtonText: 'OK',
                                                            }).then((result) => {
                                                            if (result.isConfirmed) {
                                                            } else {
                                                            }
                                                        });
                                                    }
                                                },
                                                error: function(xhr, status, error) {
                                                    console.log(error);
                                                }
                                            });                                            
                                        } else {
                                        }
                                    });
                                });
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        var err = eval("(" + xhr.responseText + ")");
                        alert("No item found!");
                    }
                }); 
                $("#item_id").val("");
                // $('#item_searchable_drop_down option[value="0"]').removeAttr('disabled');
                // $("#item_searchable_drop_down").val('0');
            }
            row_count++;
        });
        function checkQtyVsCurrentStock(class_str){
            var id_str = (class_str.id);
            var id_no = id_str.split('_')[1];
            var qty_on_hand_id = "#qty_on_hand_"+id_no;
            var qty_on_hand = parseInt($(qty_on_hand_id).val());
            var qty_id = "#qty_"+id_no;
            var qty = parseInt($(qty_id).val());
            var total_id = "#total_"+id_no;
            var bill_total_id = "#bill_total_"+id_no;
            if(qty_on_hand < qty){
                Swal.fire({
                    title: 'Insufficient Item Quantity',
                    text: 'Item Not Available',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonText: 'OK',
                    }).then((result) => {
                    if (result.isConfirmed) {
                    } else {
                    }
                });
                $(qty_id).val('');
                $(total_id).val('');
                $(bill_total_id).val('');
            }
            else{
                setTotalVal(class_str,1);
                $(qty_id).prop('disabled', true);
            }
        }
        function setTotalVal(class_str,type){
            if(type == 1){
                var id_str = (class_str.id);
                var id_no = id_str.split('_')[1];
            }
            else if(type == 2){
                var id_no = class_str.split('_')[1];
            }
            var price_id = "#sale_price_value_"+id_no;
            var price = $(price_id).val();
            var qty_id = "#qty_"+id_no;
            var qty = $(qty_id).val();
            var discount = ($("#discount_"+id_no+ " option:selected").text())/100.0;
            var amount = parseInt(price)*parseInt(qty);
            var total = amount-(discount*amount);
            $("#bill_total_"+id_no).val(amount);
            $("#total_"+id_no).val(total);
        }
        function setSubTotal(){
            var total_arr = $.map($('.total'), function (el) { return el.value; });
            var total_amount = 0;
            for (var i = 0; i < total_arr.length; i++) {
                total_amount += total_arr[i] << 0;
            }
            $("#sub_total").val(total_amount);
            setBillTotal();
            setNetTotal();
            setPaymentAmounts();
        }
        function setPaymentAmounts(){
            var net_total = $("#net_total").val();
            $("#payment_total").val(net_total);
            $("#amount_due").val(net_total);
            $("#payment_amount").val(net_total);
            setAmountMaxValue(net_total);
        }
        function setBillTotal(){
            var bill_total_arr = $.map($('.bill_total'), function (el) { return el.value; });
            var bill_total_amount = 0;
            for (var i = 0; i < bill_total_arr.length; i++) {
                bill_total_amount += bill_total_arr[i] << 0;
            }
            $("#bill_total_sum").val(bill_total_amount);
            var sub_total = $("#sub_total").val();
            var bill_total_amount = $("#bill_total_sum").val();
            var total_item_wise_discount_amount = parseInt(bill_total_amount) - parseInt(sub_total);
            $("#total_item_wise_discount_amount").val(total_item_wise_discount_amount);
        }
        function setTax(){
            var total = $("#sub_total").val();
            var tax = $("#tax").text();
            var total_with_tax = parseInt(total)+parseInt(tax);
            $("#total_with_tax").val(total_with_tax);
        }
        function setNetTotal(){
            setTax();
            var total = $("#sub_total").val();
            var tax = $("#tax").val();
            var total_with_tax = $("#total_with_tax").val();
            var total_bill_discount = $("#total_bill_discount_amount").val();
            var net_total = parseInt(total_with_tax) - parseInt(total_bill_discount);
            $("#net_total").val(net_total);
            setEarnedLoyaltyPoints();
        }
        function setAmountMaxValue(total){
            var maxValue = total;
            var inputField = $('#payment_amount');
            inputField.attr('max', maxValue);
            inputField.on('input', function() {
                var currentValue = parseInt($(this).val());
                if (currentValue > maxValue) {
                $(this).val(maxValue);
                }
            });
        }
        function setSaleItemDetails(){
            var item_id_arr = $.map($('.item_id'), function (el) { return el.value; });
            var discount_arr = $.map($('.discount'), function (el) { return el.value; });
            var sale_price_value_arr = $.map($('.sale_price_value'), function (el) { return el.value; });
            var qty_arr = $.map($('.qty'), function (el) { return el.value; });
            var batch_no_arr = $.map($('.batch_no'), function (el) { return el.value; });
            var total_arr = $.map($('.total'), function (el) { return el.value; });
            var total_item_wise_discount_amount = $("#total_item_wise_discount_amount").val();
            var pos_id = (($("#pos_machine_id").text()).split(":")[1]).trim();
            var user_id = $("#logged_user_id").val();
            var customer_id = $("#customer_id").val();
            var sale_type_id = ($("#sale_type option:selected").val());
            var authorized_by_arr = $.map($('.authorized_by'), function (el) { return el.value; });
            var payment_authorized_by_id = $("#payment_authorized_by_id").val();
            var total_amount = 0;
            for (var i = 0; i < total_arr.length; i++) {
                total_amount += total_arr[i] << 0;
            }
            $("#sub_total").val(total_amount);
            console.log(item_id_arr)
            console.log(discount_arr)
            console.log(sale_price_value_arr)
            console.log(qty_arr)
            console.log(authorized_by_arr)
            console.log(batch_no_arr)
            console.log(total_arr)
            console.log(total_item_wise_discount_amount)
            console.log(pos_id)
            console.log(customer_id)
            console.log(sale_type_id)
            console.log(total_amount)
            console.log(user_id)
            var sale_item_data_arr = [item_id_arr];
            $.each(item_id_arr, function (index, value) {
                sale_item_data_arr.push({
                    item_id_arr: item_id_arr,  
                    discount_arr: discount_arr,
                    sale_price_value_arr: sale_price_value_arr,
                    qty_arr: qty_arr,
                    authorized_by_arr: authorized_by_arr,
                    batch_no_arr: batch_no_arr,
                    total_arr: total_arr,
                    total_item_wise_discount_amount: total_item_wise_discount_amount,
                    pos_id: pos_id,
                    customer_id: customer_id,
                    sale_type_id: sale_type_id,
                    total_amount: total_amount,
                    user_id: user_id,
                    payment_authorized_by_id: payment_authorized_by_id,
                });
            });
            return sale_item_data_arr;
        }
        $("#end_sale_btn").click(function(event){
            var sale_item_data_arr = setSaleItemDetails();
            console.log(sale_item_data_arr);
            //check required validations
            if($("#sale_type").val() == 0){
                Swal.fire({
                    title: 'Sale Type not Selected',
                    text: 'Please select sale type',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonText: 'OK',
                    }).then((result) => {
                    if (result.isConfirmed) {
                    } else {
                    }
                });
            }
            else if(sale_item_data_arr.length < 2){
                Swal.fire({
                    title: 'No Items Entered',
                    text: 'Please enter sale items',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonText: 'OK',
                    }).then((result) => {
                    if (result.isConfirmed) {
                    } else {
                    }
                });
            }
            else{
                if(payment_data_ar.length < 1){
                    Swal.fire({
                        title: 'Payment Data Not Entered',
                        text: 'Please enter payment data',
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'OK',
                        }).then((result) => {
                        if (result.isConfirmed) {
                           
                        } else {
                        }
                    });
                }
                else if($("#amount_due").val() != 0){
                    if(($("#sale_type").val()) == 1){
                        Swal.fire({
                            title: 'Payment not completed',
                            text: 'Please enter due amount',
                            icon: 'warning',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                            }).then((result) => {
                            if (result.isConfirmed) {
                                $("#end_sale_btn").off('click');
                                $("#end_sale_btn").css('cursor', 'default');
                            } else {
                            }
                        });
                    }
                    else{
                        storeSale()
                    }
                }
                else{
                    storeSale();
                }
                function storeSale(){
                    $.ajax({
                        url: "submit_sale",
                        type: "POST",
                        data: {
                            sale_item_data_arr: sale_item_data_arr,
                            serial_no_data:serial_no_data,
                            payment_data_ar:payment_data_ar,
                            voucher_data_ar:voucher_data_ar,
                            loyalty_data_ar:loyalty_data_ar,
                            loyalty_redeem_data_ar:loyalty_redeem_data_ar,
                        },
                        success: function(response) {
                            console.log(response);
                            var sale_id = response.message;
                            if(response.transaction_status == false){
                                swal.fire({
                                    title: response.message_text,
                                    text: "",
                                    icon: 'warning',
                                    showCancelButton: false,
                                    confirmButtonText: 'OK',
                                }).then((result) => {
                                    if (result.isConfirmed) {
                                        window.location.href = '/sales';
                                    }
                                    else{
                                    }
                                });
                            }
                            else{
                                swal.fire({
                                    title: response.message_text,
                                    text: "",
                                    icon: 'success',
                                    showCancelButton: true,
                                    confirmButtonText: 'View',
                                }).then((result) => {
                                    if (result.isConfirmed) {
                                        // window.location.href = '/view_sales'+sale_id;
                                        window.open('/view_sales/'+sale_id, '_blank');
                                        location.reload();
                                    }
                                    else{
                                        window.location.href = '/sales'
                                    }
                                });
                            }
                        },
                        error: function(xhr, status, error) {
                            console.log(error);
                        }
                    });
                }
            }
        });
        $("#add_another_serial_btn").click(function(event){
            var sourceDiv = $('#initial_serial_div');
            var targetDiv = $('#additional_serial_div');
            targetDiv.append(sourceDiv.html());
            var serial_item_id = $(".serial_item_id").val();
            $(".serial_item_id").each(function(index, value) {
                $(this).val(serial_item_id);
            });
        });
        $("button[name='serialize_icon']").click(function() {
            alert('test');
        });
        $('#serial_data_enter_modal').on('hide.bs.modal', function (event) {
        // $("#close_serial_modal").click(function(event){
            $(".serial_item_id").each(function(index, value) {
                var serial_item_id = $(this).val();
                var serial_number = $(".serial_number").eq(index).val();
                var warranty_period = $(".warranty_period").eq(index).val();
                if((serial_number == '') || (warranty_period == '')){
                    event.preventDefault();
                    Swal.fire({
                        title: 'Serialized Item Data Not Entered',
                        text: 'Please enter serialized item data',
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'OK',
                        }).then((result) => {
                        if (result.isConfirmed) {
                        } else {
                        }
                    });
                }
                else{
                    // setSerialData();
                    $(this).modal('hide');
                }
            });
        });
        function setSerialDataClass(){
            // Select all items by class name
            var items = document.querySelectorAll('.serial_input');
            // Loop through the items
            for (var i = 0; i < items.length; i++) {
                // Check if the index is even or odd
                if (i % 2 === 0) {
                    // Set "serial_number" class for even index
                    items[i].classList.add('serial_number');
                } else {
                    // Set "warranty_period" class for odd index
                    items[i].classList.add('warranty_period');
                }
            }
        }
        function setSerialData(){
            $(".serial_input").each(function(index, value) {
                var serial_item_id = $("#modalRow").text();
                var serial_number = $(".serial_number").eq(index).val();
                var warranty_period = $(".warranty_period").eq(index).val();
                serial_no_data.push(serial_item_id+'-'+serial_number+'-'+warranty_period);
            });
            console.log(serial_no_data);
        }
        function formatSerialData(){
            for (var i = serial_no_data.length - 1; i >= 0; i--) {
                if (serial_no_data[i].includes("undefined")) {
                    serial_no_data.splice(i, 1);
                }
            }
            for (let i = serial_no_data.length - 1; i >= 0; i--) {
                if (serial_no_data.indexOf(serial_no_data[i]) !== i) {
                    serial_no_data.splice(i, 1);
                }
            }
            console.log(serial_no_data);
        }
        //payment options
        $("#add_payment_btn").click(function(event){
            $("#payment_data_enter_modal").modal('toggle'); 
            $("#payment_data_enter_modal").modal('show');
            setSubTotal();
            $("#total").val($("#net_total").val());
            if(jQuery.isEmptyObject(payment_data_ar)) {
                $("#due").val($("#net_total").val());
            }
            else{
                $("#due").val(current_due_amount);
                $("#amount_due").val(current_due_amount);
                setAmountMaxValue(current_due_amount);
            }
        });
        //set net total
        $("#total_bill_discount_amount").on("change",function(e){
            setNetTotal();
            setPaymentAmounts();
        });
        //set earned loyalty points
        function setEarnedLoyaltyPoints(){
            var net_total = $("#net_total").val();
            var loyalty_percentage = ($("#loyalty_percentage").text()).replace(/%/g, "");
            var earned_loyalty_points = parseInt(net_total) * (loyalty_percentage/100.0);
            $("#total_loyalty_points_for_this_bill").val(earned_loyalty_points);
        }
        //show/hide payment options
        $('#payment_type').on('change',function(e){
            var selected_payment_type = $(this).val();
            console.log(selected_payment_type);
            //if payment type: cash
            if(selected_payment_type == 1){
                $("#bank_div").hide();
                $("#cheque_div").hide();
                $("#card_no_div").hide();
                $("#payment_method_div").hide();
                $("#exp_date_div").hide();
                $("#gift_voucher_div").hide();
                $("#loyality_div").hide();
            }
            //if payment type: credit card
            else if(selected_payment_type == 2){
                $("#bank_div").show();
                $("#cheque_div").hide();
                $("#card_no_div").show();
                $("#payment_method_div").show();
                $("#exp_date_div").show();
                $("#gift_voucher_div").hide();
                $("#loyality_div").hide();
            }
            //if payment type: debit card
            else if(selected_payment_type == 3){
                $("#bank_div").show();
                $("#cheque_div").hide();
                $("#card_no_div").show();
                $("#payment_method_div").show();
                $("#exp_date_div").show();
                $("#gift_voucher_div").hide();
                $("#loyality_div").hide();
            }
            //if payment type: cheque
            else if(selected_payment_type == 4){
                $("#bank_div").show();
                $("#cheque_div").show();
                $("#card_no_div").hide();
                $("#payment_method_div").hide();
                $("#exp_date_div").hide();
                $("#gift_voucher_div").hide();
                $("#loyality_div").hide();
            }
            //if payment type: gift voucher
            else if(selected_payment_type == 5){
                $("#bank_div").hide();
                $("#cheque_div").hide();
                $("#card_no_div").hide();
                $("#payment_method_div").hide();
                $("#exp_date_div").hide();
                $("#gift_voucher_div").show();
                $("#loyality_div").hide();
            }
            //if payment type: loyality card
            else if(selected_payment_type == 6){
                $("#bank_div").hide();
                $("#cheque_div").hide();
                $("#card_no_div").hide();
                $("#payment_method_div").hide();
                $("#exp_date_div").hide();
                $("#gift_voucher_div").hide();
                $("#loyality_div").show();
            }
        });
        //set payment method
        $("#payment_method_visa").on('click',function(e){
            $("#payment_method").val(1);
            $("#payment_method_visa").css('border', '4px solid darkgreen');
            $("#payment_method_master").css('border', 'none');
            $("#payment_method_amex").css('border', 'none');
            $("#payment_method_cash_cheque").css('border', 'none');
            $("#payment_method_account_pay").css('border', 'none');
        });
        $("#payment_method_master").on('click',function(e){
            $("#payment_method").val(2);
            $("#payment_method_master").css('border', '4px solid darkgreen');
            $("#payment_method_visa").css('border', 'none');
            $("#payment_method_amex").css('border', 'none');
            $("#payment_method_cash_cheque").css('border', 'none');
            $("#payment_method_account_pay").css('border', 'none');
        });
        $("#payment_method_amex").on('click',function(e){
            $("#payment_method").val(3);
            $("#payment_method_amex").css('border', '4px solid darkgreen');
            $("#payment_method_visa").css('border', 'none');
            $("#payment_method_master").css('border', 'none');
            $("#payment_method_cash_cheque").css('border', 'none');
            $("#payment_method_account_pay").css('border', 'none');
        });
        $("#payment_method_cash_cheque").on('click',function(e){
            $("#payment_method").val(4);
            $("#payment_method_cash_cheque").css('border', '4px solid darkgreen');
            $("#payment_method_visa").css('border', 'none');
            $("#payment_method_master").css('border', 'none');
            $("#payment_method_amex").css('border', 'none');
            $("#payment_method_account_pay").css('border', 'none');
        });
        $("#payment_method_account_pay").on('click',function(e){
            $("#payment_method").val(5);
            $("#payment_method_account_pay").css('border', '4px solid darkgreen');
            $("#payment_method_visa").css('border', 'none');
            $("#payment_method_master").css('border', 'none');
            $("#payment_method_amex").css('border', 'none');
            $("#payment_method_cash_cheque").css('border', 'none');
        });
        //format payment data modal
        $('input[name="payment"]').change(function() {
            var payment = $('input[name="payment"]:checked').val();
            if(payment == 'full'){
                $("#submit_payment_data").text('Submit Payment');
                $("#payment_amount").val($("#total").val());
            }
            else if(payment == 'partial'){
                $("#submit_payment_data").text('Add Another Payment');    
                $("#payment_amount").val("");
            }
        });
        //check voucher validity
        $('#gift_voucher').on('change',function(event){
            var keycode = (event.keyCode ? event.keyCode : event.which);
            var gift_voucher = $("#gift_voucher").val();
            var total_amount = $("#total").val();
            //check voucher validity
            $.ajax({
                url: 'gift_card_check_voucher_validity/'+ gift_voucher+'/'+total_amount,
                method: 'GET',
                dataType: 'json',
                success: function(response) {
                    if(response.error == false){
                        if(response.voucher_validity == false){
                            swal.fire({
                                title: 'Voucher Not Valid',
                                text: "Please enter a valid voucher",
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonText: 'OK',
                                cancelButtonText: 'Cancel',
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    $("#gift_voucher").val("");
                                }
                                else{
                                    $("#gift_voucher").val("");
                                }
                            });
                        }
                        else{
                            if(response.is_sufficient == false){
                                swal.fire({
                                    title: 'Voucher Amount Insufficient',
                                    text: "Pay due from another option",
                                    icon: 'warning',
                                    showCancelButton: true,
                                    confirmButtonText: 'OK',
                                    cancelButtonText: 'Cancel',
                                }).then((result) => {
                                    if (result.isConfirmed) {
                                        $('input[name="partial"][value="partial"]').prop('checked', true);
                                        $("#payment_amount").val(response.amount);
                                        $("#keep_payment_modal_open").val(1);
                                        submitPaymentData();
                                    }
                                    else{
                                        $("#gift_voucher").val("");
                                    }
                                });
                            }
                            else if(response.expire_status == true){
                                swal.fire({
                                    title: 'Voucher Expired',
                                    text: "Approve?",
                                    icon: 'warning',
                                    input: 'password',
                                        inputAttributes: {
                                            autocapitalize: 'off'
                                        },
                                    showCancelButton: true,
                                    confirmButtonText: 'Yes',
                                    cancelButtonText: 'No',
                                    showLoaderOnConfirm: true,
                                        preConfirm: (auth_key) => {
                                        },
                                        allowOutsideClick: () => !Swal.isLoading()
                                }).then((result) => {
                                    if (result.isConfirmed) {
                                        var entered_auth_key = result.value;
                                        //check for authoization
                                        $.ajax({
                                            url: 'user_modify_sale_check_authorization/'+ entered_auth_key,
                                            type: "GET",
                                            data: {
                                                entered_auth_key: entered_auth_key,
                                            },
                                            success: function(response) {
                                                console.log(response);
                                                var is_authorized = response.is_authorized;
                                                var authorized_by = response.authorized_by;
                                                if(is_authorized){
                                                    $("#payment_authorized_by_id").val(authorized_by);
                                                }
                                                else{
                                                    Swal.fire({
                                                        title: 'Unauthorized!',
                                                        text: 'Invalid Auth Key!',
                                                        icon: 'warning',
                                                        showCancelButton: false,
                                                        confirmButtonText: 'OK',
                                                        }).then((result) => {
                                                        if (result.isConfirmed) {
                                                        } else {
                                                        }
                                                    });
                                                }
                                            },
                                            error: function(xhr, status, error) {
                                                console.log(error);
                                            }
                                        });   
                                    } 
                                    else{
                                        $("#gift_voucher").val("");
                                    }
                                });
                            }
                            else{
                                console.log(response);
                            }
                        }
                    }
                    else{
                        
                    }
                },
                error: function(xhr, status, error) {
                    console.log(xhr.responseText);
                }
            });
        });
        //submit payment data
        $('#submit_payment_data').on('click',function(e){
            submitPaymentData();
        });
        function submitPaymentData(){
            //get entered values
            var payment_type = $("#payment_type").val();
            var payment_amount = parseInt($('#payment_amount').val());
            var bank = $("#bank").val();
            var cheque_no = $("#cheque_no").val();
            var card_no = $("#card_no").val();
            var payment_method = parseInt($('#payment_method').val());
            var exp_date = $("#exp_date").val();
            var gift_voucher = $("#gift_voucher").val();
            var loyality_no = $("#loyality_no").val();
            var payment = $('#submit_payment_data').text();
            //set null if not entered
            if(cheque_no == '')
                cheque_no = null;
            if(card_no == '')
                card_no = null;  
            if(payment_method == '')
                payment_method = null;  
            if(exp_date == '')
                exp_date = null;
            if(gift_voucher == '')
                gift_voucher = null;
            if(loyality_no == '')
                loyality_no = null;
            //add to payment data array
            //format: payment_type,amount,bank,cheque,card,payment_method,exp,voucher,loyality
            payment_data_ar.push(payment_type+','+payment_amount+','+bank+','+cheque_no+','+card_no+','+payment_method+','+exp_date+','+gift_voucher+','+loyality_no);
            if(gift_voucher != null)
                voucher_data_ar.push(gift_voucher);
            //earned loyalty points
            //format:loyalty_percentage,customer_id,loyalty_amount,is_cash,cash_amount,loyalty_auth_code
            var loyalty_percentage = ($("#loyalty_percentage").text()).replace(/%/g, "");
            var customer_id = $("#customer_id").val();
            var loyalty_amount = $("#total_loyalty_points_for_this_bill").val();
            var balace_cash_to_loyalty = $("#balace_cash_to_loyalty").val();
            var loyalty_auth_code = $("#loyalty_auth_code").val();
            if(balace_cash_to_loyalty == 0){
                var is_cash = 0;
                var cash_amount = 0;
            }
            else{
                var is_cash = 1;
                var cash_amount = balace_cash_to_loyalty;
            }
            loyalty_data_ar.push(loyalty_percentage+','+customer_id+','+loyalty_amount+','+is_cash+','+cash_amount+','+loyalty_auth_code);
            var customer_loyalty_ids = $("#customer_loyalty_ids").val();
            var customer_loyalty_amounts = $("#customer_loyalty_amounts").val();
            var loyalty_ids_count = $("#loyalty_ids_count").val();
            loyalty_redeem_data_ar.push(loyalty_ids_count+'-'+customer_loyalty_ids+'-'+customer_loyalty_amounts);
            //reset payment data modal fields
            $("#payment_type").val('');
            $('#payment_amount').val('');
            $("#bank").val('');
            $("#cheque_no").val('');
            $("#card_no").val('');
            $("#payment_method").val('');
            $("#exp_date").val('');
            $("#gift_voucher").val('');
            $("#gift_voucher").val('');
            $("#loyality_no").val('');
            $("#payment_method_visa").css('border', 'none');
            $("#payment_method_master").css('border', 'none');
            $("#payment_method_amex").css('border', 'none');
            $("#payment_method_cash_cheque").css('border', 'none');
            $("#payment_method_account_pay").css('border', 'none');
            console.log(payment_data_ar);
            if(payment == 'Submit Payment'){
                var net_total = parseInt($("#total").val());
                var paid = 0;
                $.each(payment_data_ar, function(index, element) {
                    var values = element.split(',');
                    paid += parseInt(values[1]);
                });
                var due = net_total-paid;
                current_due_amount = due;
                $("#due").val(due);
                $("#payment_total").val(paid);
                $("#amount_due").val(due);
                $("#payment_data_enter_modal").modal('hide');
                setAmountMaxValue(due);
            }
            else if('Add Another Payment'){
                var net_total = parseInt($("#total").val());
                var paid = 0;
                $.each(payment_data_ar, function(index, element) {
                    var values = element.split(',');
                    paid += parseInt(values[1]);
                });
                var due = net_total-paid;
                current_due_amount = due;
                $("#due").val(due);
                $("#payment_total").val(paid);
                $("#amount_due").val(due);
                setAmountMaxValue(due);
                if(due == 0){
                    $("#payment_total").val(paid);
                    $("#amount_due").val(due);
                    $('#submit_payment_data').text('Submit Payment');
                    $("#payment_data_enter_modal").modal('hide');
                }
            }
            //disable add payment button
            if($("#amount_due").val() == 0){
                $("#add_payment_btn").hide();
                $("#edit_payment_btn").show();
                // $("#add_payment_btn").off('click');
                // $("#add_payment_btn").css('cursor', 'default');
            }
            //enable add payment button
            //payment options
            $("#edit_payment_btn").click(function(event){
                Swal.fire({
                    title: 'Enter Auth Key',
                    input: 'password',
                    inputAttributes: {
                        autocapitalize: 'off',
                        autocomplete: 'off'
                    },
                    showCancelButton: true,
                    confirmButtonText: 'Authorize',
                    showLoaderOnConfirm: true,
                    preConfirm: (auth_key) => {
                    },
                    allowOutsideClick: () => !Swal.isLoading()
                })
                .then((result) => {
                    if (result.isConfirmed) {
                        var entered_auth_key = result.value;
                        //check for authoization
                        $.ajax({
                            url: 'user_modify_sale_check_authorization/'+ entered_auth_key,
                            type: "GET",
                            data: {
                                entered_auth_key: entered_auth_key,
                            },
                            success: function(response) {
                                console.log(response);
                                var is_authorized = response.is_authorized;
                                var authorized_by = response.authorized_by;
                                if(is_authorized){
                                    $("#add_payment_btn").show();
                                    $("#edit_payment_btn").hide();
                                    $("#payment_authorized_by_id").val(authorized_by);
                                    $("#payment_data_enter_modal").modal('toggle'); 
                                    $("#payment_data_enter_modal").modal('show');
                                    $("#total").val($("#net_total").val());
                                }
                                else{
                                    Swal.fire({
                                        title: 'Unauthorized!',
                                        text: 'Invalid Auth Key!',
                                        icon: 'warning',
                                        showCancelButton: false,
                                        confirmButtonText: 'OK',
                                        }).then((result) => {
                                        if (result.isConfirmed) {
                                        } else {
                                        }
                                    });
                                }
                            },
                            error: function(xhr, status, error) {
                                console.log(error);
                            }
                        });                                            
                    } else {
                    }
                });
            });
            addPaymentDataToTable();
        }
        //add entered payment data to view table
        function addPaymentDataToTable(){
            $('#entered_payment_data_div').empty();
            $('#payment_data_tbl_div').empty();
            var table = $('<table>');
            var headers = $('<tr>').append($('<th>').text('Payment Method')).append($('<th style="color:white;">').text('xxxxxxxxxxxxx')).append($('<th>').text('Paid Amount')).append($('<th style="color:white;">').text('xxxxxxxxxxxxx')).append($('<th>').text('Action'));
            table.append(headers);
            for(i=0;i<payment_data_ar.length;i++){
                var payment_type = (payment_data_ar[i].split(","))[0];
                var amount = (payment_data_ar[i].split(","))[1];
                var payment_type_text;
                if(payment_type == 1){
                    payment_type_text = "Cash";
                }
                else if(payment_type == 2){
                    payment_type_text = "Credit card";
                }
                else if(payment_type == 3){
                    payment_type_text = "Debit card";
                }
                else if(payment_type == 4){
                    payment_type_text = "Cheque";
                }
                else if(payment_type == 5){
                    payment_type_text = "Gift voucher";
                }
                else if(payment_type == 6){
                    payment_type_text = "Loyality card";
                }
                var action = '<div name="payment_delete_icon" class="btn-outline-danger text-danger fw-bold h5 text-strock-1" style="cursor:pointer;" id="payment_delete_icon_'+(i+1)+'"><i class="bi bi-x-square"></i></div>';
                var row = $('<tr>').append($('<td>').text(payment_type_text)).append($('<td  style="color:white;">').text("xxxxxxxxxxxxx")).append($('<td>').text(amount)).append($('<td  style="color:white;">').text("xxxxxxxxxxxxx")).append(action);
                table.append(row);
            } 
               
            var tableClone1 = table.clone();
            $('#entered_payment_data_div').append(tableClone1);
            var tableClone2 = table.clone().attr('id', 'payment_summary_view_tbl');
            $("#payment_summary_view_tbl th:last-child, #payment_summary_view_tbl td:last-child").remove();
            $('#payment_data_tbl_div').append(tableClone2);
        }
        $('#payment_data_enter_modal').on('hide.bs.modal', function(event) {
            if ($("#keep_payment_modal_open").val() == 1) {
                event.preventDefault(); 
                $("#keep_payment_modal_open").val(0);
            }
        });
        //redeem loyaty points
        $("#loyalty_auth_code").on("change",function(e){
            var pay_amount = $("#payment_amount").val();
            var customer_id = $("#customer_id").val();
            $.ajax({
                    url: '/set_customer_loyalty_redeem_data/'+ pay_amount+'/'+customer_id,
                    method: 'GET',
                    dataType: 'json',
                    success: function(response) {
                        if(response.customer_loyalty_ids.length > 1){
                            var customer_loyalty_ids_str = (response.customer_loyalty_ids).join(", ");
                            var customer_loyalty_amounts_str = (response.customer_loyalty_amounts).join(", ");
                        }
                        else{
                            var customer_loyalty_ids_str = response.customer_loyalty_ids;
                            var customer_loyalty_amounts_str = response.customer_loyalty_amounts;
                        }
                        $("#loyalty_ids_count").val(response.customer_loyalty_ids.length);
                        $("#customer_loyalty_ids").val(customer_loyalty_ids_str);
                        $("#customer_loyalty_amounts").val(customer_loyalty_amounts_str);
                    },
                    error: function(xhr, status, error) {
                        console.log(xhr.responseText);
                    }
            });
        });
        //update amount data
        $("#sale_tbl_div").on("click",function(e){
            setSubTotal();
            $("#amount_due").val($("#due").val());
            $("#total").val($("#net_total").val());
        });
        //check for duplicate serial number entries
        function checkDuplicateSerialNumbers() {
            var values = [];
            var duplicateFound = false;
            var inputs = document.getElementsByClassName('serial_number');
            for (var i = 0; i < inputs.length; i++) {
                var value = inputs[i].value.trim();
                if (value !== '') {
                if (values.indexOf(value) > -1) {
                    duplicateFound = true;
                    break;
                }
                values.push(value);
                }
            }
            if (duplicateFound) {
                Swal.fire({
                        title: 'Duplicate Serial Numbers Entered',
                        text: 'Please re-check',
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'OK',
                        }).then((result) => {
                        if (result.isConfirmed) {
                        } else {
                        }
                    });
            } else {
            }
        }
        //reset form
        $('#serial_data_enter_modal').on('hidden.bs.modal', function (e) {
            // Clear the form fields
            $(this).find('form').trigger('reset');
            $(this).find('.text-danger').remove();
        });
        //function key press actions
        $(document).on('keydown', function(event) {
            // Check if the key pressed is the "F1" key (key code 112)
            if (event.keyCode === 112) {
                window.open('/items', '_blank');
            }
        });
        
    </script>

<?php $this->endSection() ?>