<?php $this->extend('layouts/master') ?>
    <?php $this->section('customer_contact_information') ?>
        <?php if (session()->has('success')): ?>
            <div class="alert alert-success"><?= session('success') ?></div>
        <?php endif; ?>
        <!---List: Start --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#insert_modal"><i class="bi bi-plus-lg fw-bold"></i> Add Category Information </button>
                                                   
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>                               
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                    <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                        <th class="p-2" scope="col">ID</th>
                                            <th class="p-2" scope="col">Category Name</th>
                                            <th class="p-2" scope="col">Parent Category Name</th>
                                            <th class="p-2" scope="col">Status</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                       
                                            <?php 
                                                if($sources):
                                                foreach($sources as $source): 
                                            ?>
                                            <tr id="<?php echo $source['ICID']; ?>">  
                                                <td><?php echo $source['ICID']; ?></td>  
                                                <td>
                                                <?php                                                    
                                                    echo $source['ICName'];
                                                ?>
                                                </td>  
                                                <td><?php echo $source['ICParentCatName']; ?></td>  
                                                <td>
                                                        <?php 
                                                                if(($source['current_status'] == '2') || ($source['current_status'] == '3')):
                                                            ?>
                                                               <div class="form-check form-switch">
                                                                    <input class="form-check-input" type="checkbox" role="switch" id="enable" data-id="<?php echo  $source['ICID']; ?>" />
                                                                </div>
                                                                
                                                            <?php
                                                                elseif(($source['current_status'] == '1') ):
                                                            ?>
                                                                <div class="form-check form-switch">
                                                                    <input class="form-check-input" type="checkbox" role="switch" id="disable" data-id="<?php echo  $source['ICID']; ?>" checked/>
                                                                </div>
                                                            <?php
                                                                endif;
                                                            ?>
                                                    </td>
                                                <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="edit" type="button" data-bs-toggle="modal" data-bs-target="#insert_modal" data-id="<?php echo $source['ICID']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="delete" type="button" data-id="<?php echo $source['ICID']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- List: End --->
        <!--- Start cat info--->
        <div class="modal fade" id="insert_modal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Item Category Detail Form</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row mb-3" id="addCategory">
                            <form action="/insert_category_info" method="post" id="catinfo" accept-charset="utf-8">
                                <label for="Last-name" class="col-form-label">Add Category</label>
                                <input type="hidden" class="form-control mb-3" name="ICID" id="ICID" placeholder="Enter Category ID" value="<?php echo set_value('ICID');?>">
                                <input type="text" class="form-control mb-3" name="ICName" id="ICName" placeholder="Enter Category Name">
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ICName') : '' ?></h6>  
                                <label for="parentId" class="col-form-label">Select Parent ID</label>
                                <select class="form-control mb-3" name="ICParentID" id="ICParentID"> 
                                    <option value="">Select ID</option> 
                                    <?php                                        
                                     if($sources):
                                        foreach($sources as $source):
                                    ?>
                                    <option  value="<?php  echo $source['ICID']?>" id="<?php echo $source['ICID']; ?>" >
                                        <?php
                                            $levelSpace = '';
                                            for ($i = 1; $i <= $source['ICLevel']; $i++) {
                                                if ($i <= $source['ICLevel']) {
                                                    $levelSpace .= '&nbsp;&nbsp;&nbsp;';
                                                }
                                            }
                                            if($source['ICParentID'] == ''){
                                                echo $source['ICID'].' - '. $source['ICName'];
                                            }else{
                                                echo $levelSpace .$source['ICID'].' - '. $source['ICName'];
                                            }
                                        ?>
                                   <?php
                                        endforeach;
                                    endif;
                                   ?>                                 
                                </select>
                                <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="submit" >Submit</button>
                            </form>         
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- End cat information   --->
    </section>
    <?php echo view('includes/footer'); ?>
    <?php
        // Retrieve the flash data
        $session = session();
        $successTitle = $session->getFlashdata('title');
        $successMessage = $session->getFlashdata('message');
        $icon = $session->getFlashdata('icon');

        // Check if flash data exists
        if ($successTitle && $successMessage) {
            // Print the success message with seet alert            
            echo "<script>
                    $(document).ready(function() {
                        swal.fire({
                            title: '$successTitle',
                            text: '$successMessage',
                            icon: '$icon',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                        });
                    });
                </script>";
        }
    ?>
    <script>
        function openInsertModal(){
            var insert_modal = $("#insert_modal");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                insert_modal.modal('show');
            }
        }
        jQuery(document).ready(function() {
            openInsertModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });

            Table = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                Table.search($(this).val()).draw() ;
            });

            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    Table.rows().select();        
                } else {
                    Table.rows().deselect(); 
                }
            });

            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });

        //update
        $('body').on('click', '#edit', function () { 
            var id = $(this).attr('data-id');
            $.ajax({
               url: 'item_category_infomation_edit/'+id,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    console.log(res.data);
                    $('#insert_modal').modal('show');
                    $('#catinfo #id').val(res.data.ICID); 
                    $('#catinfo #ICID').val(res.data.ICID);
                    $('#catinfo #ICName').val(res.data.ICName); 
                    // var pid=res.data.ICParentID+ "-" +res.data.ICParentCatName;
                    // console.log(pid);
                    $('#catinfo #ICParentID').val(res.data.ICParentID); 
                    $('#catinfo #ICParentID').find('option[value="' + res.data.ICID + '"]').prop('disabled', true);
                },
                error: function(xhr, status, error) {
                    console.log(res);
                    var err = eval("(" + xhr.responseText + ")");
                    alert(err.Message);
                }
            });
        });

        //delete cat_info
        $('body').on('click', '#delete', function () {
            var id = $(this).attr('data-id');
            $.get('item_category_infomation_delete/'+id, function (data) {
                if(data.error){
                    console.log(data.error);
                    swal.fire({
                        title: 'Can not delete',
                        text: data.message,
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'OK',
                    });
                }else{
                    // location.reload() 
                    console.log(data.error);
                    swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, delete it!',
                    }).then((result) => {
                        location.reload();
                        $('#viewtable tbody #'+ id).remove();
                    });
                }
            });
        });

             //item category disable
             $('body').on('change', '#disable', function () 
        {
            var id = $(this).attr('data-id');
            //  alert(id);
            $.getJSON('disable_item_category/'+id, function (data) {                
                 location.reload();
                    })
                    location.reload();
        });
        
        //item category enable
        $('body').on('change', '#enable', function () 
        {
            var id = $(this).attr('data-id');
            $.getJSON('enable_item_category/'+id, function (data) {
                location.reload();
            })
            
        });
        //reset form
        $('#insert_modal').on('hidden.bs.modal', function (e) {
            // Clear the form fields
            $(this).find('form').trigger('reset');
            $(this).find('.text-danger').remove();
            $('#ICParentID option').removeAttr('disabled');
        });

        // prevent multi submit
        document.querySelector('form').addEventListener('submit', function() {
            document.querySelector('#submit').disabled = true;
        });
    </script>
<?php $this->endSection() ?>