<?php $this->extend('layouts/master') ?>

<?php $this->section('gift_card') ?>

        <!---List of Customers --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="flex-fill bd-highlight">
                                        <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                            <div class="d-flex bd-highlight">
                                                <div class="flex-fill bd-highlight">
                                                    <div class="ms-2 py-0 text-primary fw-bold">
                                                        <!-- <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#gift_cardModal"><i class="bi bi-plus-lg fw-bold"></i>New Gift Card </button> -->
                                                        <button class="btn linear-bg text-secondary px-2 py-0" type="button"><i class="bi bi-plus-lg fw-bold"></i>
                                                        <a href="/gift_voucher_sale" class="text-secondary text-decoration-none">    
                                                            New Gift Card
                                                        </a>
                                                    </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                    <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                            <th class="p-2" scope="col">Card Issue Date</th>
                                            <th class="p-2" scope="col">Card Expire Date</th>
                                            <th class="p-2" scope="col">Amount</th>
                                            <th class="p-2" scope="col">Serial  Number</th>
                                            <th class="p-2" scope="col">Enable/Disable</th> 
                                            <th class="p-2" scope="col">Status</th> 
                                            <!-- <th class="p-2 rounded-end" scope="col">Actions</th> -->
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                       
                                            <?php 
                                                if($sources):
                                                foreach($sources as $source): 
                                                foreach($source as $s): 
                                                  
                                            ?>
                                            <tr id="<?php echo $s['id']; ?>">     
                                                <td><?php echo $s['giftcard_issue_date']; ?></td>
                                                <td><?php echo $s['giftcard_expire_date']; ?></td>
                                                <td><?php echo $s['amount']; ?></td>
                                                <td><?php echo $s['serial_number']; ?></td>
                                                <td>
                                                        <?php 
                                                            if($s['current_status'] == '1'):
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="enable" data-id="<?php echo  $s['id']; ?>" checked/>
                                                            </div>
                                                        <?php
                                                            else:
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="disable" data-id="<?php echo  $s['id']; ?>" />
                                                            </div>
                                                        <?php
                                                            endif;
                                                        ?>
                                                </td>   
                                                <?php 
                                                    if($s['is_used']=='0'){
                                                ?>
                                                
                                                    <?php 
                                                            $currentDate = date("Y-m-d"); 
                                                            if($s['giftcard_expire_date']>$currentDate){
                                                     ?>
                                                        <td>Active</td>
                                                    <?php }
                                                            else{
                                                    ?>
                                                        <td>expired</td>
                                                    <?php }
                                                    ?>
                                                
                                                <?php }
                                                    else{
                                                ?>
                                                      <td>used</td>
                                                    <?php }
                                                    ?>
                                                <!-- <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="gCardEdit" type="button" data-bs-toggle="modal" data-bs-target="#gift_cardModal" data-id="<?php echo $s['id']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="gCarddelete" type="button" data-id="<?php echo $s['id']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td> -->
                                            </tr>
                                            <?php
                                                    
                                                endforeach;
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- start gift card data insert and update model -->
        <div class="modal fade" id="gift_cardModal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Gift Card Detail Form</h5>
                        <button type="button" id="closefrm" class="btn-close bg-secondary" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form method="post" id="add_giftCard" name="add_giftCard" action="<?= site_url('/submit_gift_card') ?>">
                            <div class="row">
                                <div class="mb-3 col">
                                    <input type="hidden" class="form-control mb-3" name="id" id="id" hidden  value="<?php echo set_value('id');?>">
                                    <label for="issuedate" class="col-form-label">Enter Gift Card Issue Date:</label>  
                                    <input type="date" class="form-control"  value="<?php echo set_value('issue_date');?>" name="issue_date" id="issue_date" placeholder="Enter Gift Card Issue Date">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'issue_date') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="expdate" class="col-form-label">Enter Gift Card Expire Date:</label>  
                                    <input type="date" class="form-control" value="<?php echo set_value('exp_date');?>" name="exp_date" id="exp_date" placeholder="Enter Gift Card Expire Date">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'exp_date') : '' ?></h6>
                                </div>
                            </div>
                            <div class="row">
                                <div class="mb-3 col">
                                    <label for="amount" class="col-form-label">Amount:</label>  
                                    <input type="text" class="form-control"  value="<?php echo set_value('amount');?>" name="amount" id="amount" placeholder="Amount">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'amount') : '' ?></h6>
                                   
                                </div>
                                <div class="mb-3 col">
                                    <label for="searilNumber" class="col-form-label">Serial Number:</label>  
                                    <input type="text" class="form-control"  value="<?php echo set_value('serial_number');?>" name="serial_number" id="serial_number" placeholder="Serial Number">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'serial_number') : '' ?></h6>
                                </div>
                            </div> 
                            <div class="row">
                                <div class="mb-3 col">
                                    <!-- <label for="issuedby" class="col-form-label">Issued By:</label>   -->
                                    <input type="hidden" class="form-control"  value="<?= $userinfo->UserName; ?>" name="issued_name" id="issued_name" placeholder="Issued By">
                                   
                                </div>
                            </div>                            
                            <div class="row">
                                <div class="mb-3 col">
                                    <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="submit">Submit</button>
                                </div>                            
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- end  gift card data insert and update  model -->
    </section>
    <?php echo view('includes/footer'); ?>
    <?php
        // Retrieve the flash data
        $session = session();
        $successTitle = $session->getFlashdata('title');
        $successMessage = $session->getFlashdata('message');

        // Check if flash data exists
        if ($successTitle && $successMessage) 
        {
            // Print the success message with seet alert            
            echo "<script>
                    $(document).ready(function() {
                        swal.fire({
                            title: '$successTitle',
                            text: '$successMessage',
                            icon: 'success',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                        });
                    });
                </script>";
        }
    ?>
    <script>
        function openGiftCardModal()
        {
            var gift_card_modal = $("#gift_cardModal");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                gift_card_modal.modal('show');
            }
        }
        $(document).ready(function() 
        {
            openGiftCardModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            EmpTable = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                EmpTable.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    EmpTable.rows().select();        
                } else {
                    EmpTable.rows().deselect(); 
                }
            });

            $.extend( DataTable.ext.classes, 
            {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });
        //Check All
        function checkAll(o)
         {
            var boxes = document.getElementsByClassName("select-checkbox");
            for (var x = 0; x < boxes.length; x++) {
                var obj = boxes[x];
                if (obj.type == "checkbox") {
                if (obj.name != "check")
                    obj.checked = o.checked;
                }
            }
        }                
        //update bank
        $('body').on('click', '#gCardEdit', function ()
         {
            var id = $(this).attr('data-id');
            // alert(id);
            $.ajax({
            
                url: 'gift_card_edit/'+id,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    console.log(res.data);
                    $('#gift_cardModal').modal('show');
                    $('#add_giftCard #id').val(res.data.id); 
                    $('#add_giftCard #issue_date').val(res.data.giftcard_issue_date); 
                    $('#add_giftCard #exp_date').val(res.data.giftcard_expire_date);
                    $('#add_giftCard #amount').val(res.data.amount);
                    $('#add_giftCard #serial_number').val(res.data.serial_number);
                    $('#add_giftCard #issued_name').val(res.data.giftcard_issued_by);
                },
                    error: function (data) {
                        console.log('err');
                }
            });
        });
         //delete bank
         $('body').on('click', '#gCarddelete', function ()
          {
                var id = $(this).attr('data-id');
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $('#viewtable tbody #'+ id).remove();
                    $.ajax({
                        type: 'GET',
                        dataType: 'json',
                        url: 'gift_card_delete/'+id,
                        async: false,
                        success: function(data){    
                            location.reload()                  
                            swal.fire({
                                icon: data.icon,
                                title: data.title,
                                text: data.message,
                            });
                            if(data['status'] == 'true'){
                               
                                $('#viewtable #'+ id).remove();
                               
                            }
                        }
                    });
                }
            });          
        });
        //start and end date 
        $("body").on("change", "#issue_date", function () 
        {
            var myDate = new Date($(this).val());
            var d = new Date(myDate),
            month = '' + (d.getMonth() + 1),
            day = '' + d.getDate(),
            year = d.getFullYear();
            if (month.length < 2) month = '0'+ month;
            if (day.length < 2) day = '0'+day;
                var minDate = [year, month, day].join('-');
                //alert(minDate);
            $("#exp_date").attr('min',minDate);
        });

        //gift card disable
        $('body').on('change', '#disable', function () 
        {
                    var id = $(this).attr('data-id');
                    //  alert(id);
                    $.getJSON('enable_gift_card/'+id, function (data) {                
                    location.reload();
                            })
        });
            //gift card enable
        $('body').on('change', '#enable', function () 
        {
                    var id = $(this).attr('data-id');
                    $.getJSON('disable_gift_card/'+id, function (data) {
                        location.reload();
                    })
         });
        //reset form
        $('#gift_cardModal').on('hidden.bs.modal', function (e) 
        {
            // Clear the form fields
            $(this).find('form').trigger('reset');
            $(this).find('.text-danger').remove();
        });

        // prevent multi submit
        document.querySelector('form').addEventListener('submit', function() 
        {
            document.querySelector('#submit').disabled = true;
        });
                  
    </script>
<?php $this->endSection() ?>