<?php $this->extend('layouts/master') ?>
<?php $this->section('customer_contact_information') ?>
        <!---List: Start --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>                                    
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <a href="/customer" class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                        <!--i class="bi bi-plus-lg fw-bold"></i-->Customer
                                                    </a>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#submit_modal">
                                                        <i class="bi bi-plus-lg fw-bold"></i>New Customer Contact Information
                                                    </button>                                                   
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                    <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                        <th class="p-2" scope="col">ID</th>
                                            <th class="p-2" scope="col">Customer ID</th>
                                            <th class="p-2" scope="col">Address</th>
                                            <th class="p-2" scope="col">Phone Number</th>
                                            <th class="p-2" scope="col">Email</th>
                                            <th class="p-2" scope="col">Is Default</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                       
                                            <?php 
                                                if($sources):
                                                foreach($sources as $source):
                                                foreach($source as $s): 
                                            ?>
                                            <tr id="<?php echo $s['id']; ?>">   
                                                <td><?php echo $s['id']; ?></td>  
                                                <td><?php echo $s['customer_id']; ?></td>  
                                                <td><?php echo $s['address']; ?></td>
                                                <td><?php echo $s['phone_number']; ?></td>
                                                <td><?php echo $s['email']; ?></td>
                                                <td>
                                                    <span class="dt-button buttons-csv buttons-html5 btn linear-bg text-secondary px-2 py-0" style="cursor:text !important">
                                                        <?php 
                                                            if($s['is_default'] == 1){
                                                                echo 'Default';
                                                            }
                                                        ?>
                                                    </span>
                                                    <span id="change_customer_contact_info_default_status" name="change_customer_contact_info_default_status" class="dt-button buttons-csv buttons-html5 btn linear-bg text-secondary px-2 py-0" style="" data-id="<?php echo $s['id']; ?>">
                                                        <?php 
                                                            if($s['is_default'] == 1){
                                                                echo 'X';
                                                            }
                                                        ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="edit" type="button" data-bs-toggle="modal" data-bs-target="#submit_modal" data-id="<?php echo $s['id']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <?php 
                                                        if($s['is_default'] == 0){
                                                    ?>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="delete" type="button" data-id="<?php echo $s['id']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- List: End --->
                                    
        <!--- Insert/update: Start --->
        <div class="modal fade" id="submit_modal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Add New Customer Contact Information</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                    <form method="post" id="add_contact_info" name="add_contact_info" action="<?= site_url('submit_customer_contact_information') ?>">
                        <input type="text" id="id" name="id" class="form-control" hidden value="<?php echo set_value('id');?>">
                        <input hidden type="text" id="customer_default_contact_data" name="customer_default_contact_data" value="<?php echo set_value('customer_default_contact_data');?>">
                            <div class="row">
                                <div class="mb-3 col">
                                    <label for="customer_id" class="col-form-label">Customer:</label>
                                    <select class="form-control" name="customer_id" id="customer_id">
                                        <option value="0">--Select Customer--</option>
                                        <?php foreach($customers as $customer){?>
                                            <option value="<?php echo $customer['id'] ;?>" <?php echo set_select('customer_id',$customer['id']);?> ><?php echo $customer['first_name'].' '.$customer['last_name'];?></option>
                                        <?php }?>
                                    </select>
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'customer_id') : '' ?></h6>
                                </div>
                            </div>
                            <div class="row">
                                <div class="mb-3 col">
                                    <label for="email" class="col-form-label">Enter Email:</label>
                                    <input type="email" class="form-control" name="email" id="email" placeholder="Enter Email" value="<?php echo set_value('email');?>">
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'email') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="phone_number" class="col-form-label">Phone Number:</label>
                                    <input type="tel" id="phone_number" name="phone_number" class="form-control phone_number" value="<?php echo set_value('phone_number');?>">
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'phone_number') : '' ?></h6>
                                </div>
                                <div class="mb-3 col" id="is_default_div" style="display:none" >
                                    <label for="is_default_chk"> Is Default</label>
                                    <input type="checkbox" id="is_default_chk" name="is_default_chk" value="0" value="<?php echo set_value('is_default_chk');?>">
                                    <input type="text" id="is_default" name="is_default" hidden value="<?php echo set_value('is_default');?>">
                                </div>
                            </div>
                            <div class="row">    
                                <div class="mb-3 col">
                                    <label for="address" class="col-form-label">Address:</label>
                                    <textarea name="address" id="address" cols="30" rows="5" placeholder="Enter Address" class="form-control" ><?php echo set_value('address');?></textarea>
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'address') : '' ?></h6>
                                </div>
                                <div class="row">
                                    <div class="mb-3 col">
                                        <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="submit">Submit</button>
                                    </div>    
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!--- Insert/update: End --->
    </section>
    <?php echo view('includes/footer'); ?>
    
    <?php
        // Retrieve the flash data
        $session = session();
        $successTitle = $session->getFlashdata('title');
        $successMessage = $session->getFlashdata('message');

        // Check if flash data exists
        if ($successTitle && $successMessage) {
            // Print the success message with seet alert            
            echo "<script>
                    $(document).ready(function() {
                        swal.fire({
                            title: '$successTitle',
                            text: '$successMessage',
                            icon: 'success',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                        });
                    });
                </script>";
        }
    ?>
    <script>
        function openSubmitModal(){
            var submit_modal = $("#submit_modal");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                submit_modal.modal('show');
            }
        }
        $('#submit_modal #is_default_chk').click(function() {
            if($("#submit_modal #is_default_chk").is(':checked')){
                $("#submit_modal #is_default").val(1);  
            }
            else{
                $("#submit_modal #is_default").val(0); 
            }
        });
        $('#submit_modal #is_default_chk').click(function() {
            if($("#submit_modal #is_default_chk").is(':checked')){
                $("#submit_modal #is_default").val(1);  
            }
            else{
                $("#submit_modal #is_default").val(0); 
            }
        });
        jQuery(document).ready(function() {
            openSubmitModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            Table = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                Table.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    Table.rows().select();        
                } else {
                    Table.rows().deselect(); 
                }
            });
            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });                      
        //update
        $('body').on('click', '#edit', function () {
            var id = $(this).attr('data-id');
            $.ajax({
                url: 'customer_contact_information_edit/'+id,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    $('#submit_modal').modal('show');
                    $('#submit_modal #id').val(res.data.id); 
                    $('#submit_modal #customer_default_contact_data').val(res.customer_default_contact_data); 
                    $('#submit_modal #customer_id').val(res.data.customer_id); 
                    $('#submit_modal #address').val(res.data.address);
                    $('#submit_modal #phone_number').val(res.data.phone_number);
                    $('#submit_modal #email').val(res.data.email);
                    $('#submit_modal #is_default').val(res.data.is_default);
                    if(res.data.is_default == 1){
                        $('#submit_modal #is_default_chk').prop("checked", true);
                    }
                    if(res.data.is_default == 0){
                        $('#submit_modal #is_default_chk').prop("checked", false);  
                    }
                    if(res.customer_default_contact_data < 1)
                        $('#submit_modal #is_default_div').show();
                    else
                        $('#submit_modal #is_default_div').hide();
                },
                error: function(xhr, status, error) {
                    var err = eval("(" + xhr.responseText + ")");
                    alert(err.Message);
                }
            });
        });

        //  delete customer contact informations
        $('body').on('click', '#delete', function () {
            var id = $(this).attr('data-id');
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $('#viewtable tbody #'+ id).remove();
                    $.ajax({
                        type: 'GET',
                        dataType: 'json',
                        url: 'customer_contact_information_delete/'+id,
                        async: false,
                        success: function(data){  
                            location.reload()                     
                            swal.fire({
                                icon: data.icon,
                                title: data.title,
                                text: data.message,
                            });
                            if(data['status'] == 'true'){
                                $('#viewtable tbody #'+ id).remove();
                            }
                        }
                    });
                }
            });          
        });
        //reset form
        $('#submit_modal').on('hidden.bs.modal', function (e) {
            $(this).find('form').trigger('reset');
            $(this).find('.text-danger').remove();
        });

        // prevent multi submit
        document.querySelector('form').addEventListener('submit', function() {
            document.querySelector('#submit').disabled = true;
        });
        //change customer contact info default status
        $('body').on('click', '#change_customer_contact_info_default_status', function (e) {
            // e.preventDefault(); 
            var id = $(this).attr('data-id');
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, change status!',
                timer: 55000,
		    }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'GET',
                        //dataType: 'json',
                        url: 'customer_contact_information_change_customer_contact_info_default_status/'+id,
                        // async: false,
                        success: function(response){
                            //console.log(response);
                            if(response.icon == 'success'){
                                swal.fire({
                                    icon: response.icon,
                                    title: response.title,
                                    text: response.message,
                                    showCancelButton: false,
                                    confirmButtonText: 'Ok',
                                });
                                location.reload();
                            }else{
                                swal.fire({
                                    icon: response.icon,
                                    title: response.title,
                                    text: response.message,
                                    showCancelButton: false,
                                    confirmButtonText: 'Ok',
                                });
                            }
                        },
                        error: function(XMLHttpRequest, textStatus, errorThrown){
                            // console.log(XMLHttpRequest);
                            // console.log(textStatus);
                            // console.log(errorThrown);
                            window.location.href = '/customer_contact_information';
                        }
                    });
                }
            });          
        });
                  
    </script>
<?php $this->endSection() ?>