<?php $this->extend('layouts/master') ?>
<?php $this->section('customer') ?>
        <!---List: Start --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#submit_modal">
                                                        <i class="bi bi-plus-lg fw-bold"></i>Customer Data
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                        <a href="/customer_contact_information" class="text-secondary text-decoration-none">    
                                                            <!--i class="bi bi-plus-lg fw-bold"></i--> Customer Contact Information
                                                        </a>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">                                
                                    <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded ">
                                            <th class="p-2 " scope="col">Customer ID</th>
                                            <th class="p-2 nosort " scope="col">First Name</th>
                                            <th class="p-2 " scope="col">Last Name</th>
                                            <th class="p-2 " scope="col">Status</th>
                                            <th class="p-2  rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                       
                                            <?php 
                                                if($sources):
                                                foreach($sources as $source): 
                                                foreach($source as $s): 
                                            ?>
                                            <tr id="<?php echo $s['id']; ?>">   
                                                <td><?php echo $s['id']; ?></td>  
                                                <td><?php echo $s['first_name']; ?></td>
                                                <td><?php echo $s['last_name']; ?></td>
                                                <td>
                                                        <?php 
                                                            if($s['current_status'] == '1'):
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="enable" data-id="<?php echo  $s['id']; ?>" checked/>
                                                            </div>
                                                        <?php
                                                            else:
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="disable" data-id="<?php echo  $s['id']; ?>" />
                                                            </div>
                                                        <?php
                                                            endif;
                                                        ?>
                                                </td>  
                                                <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="edit" type="button" data-bs-toggle="modal" data-bs-target="#submit_modal" data-id="<?php echo $s['id']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="delete" type="button" data-id="<?php echo $s['id']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- List: End --->
        <!--- Insert/update: Start --->
        <div class="modal fade" id="submit_modal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Add New Customer</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form method="post" id="add" name="add" action="<?= site_url('submit_customer') ?>">
                            <input type="text" id="id" name="id" placeholder="Customer ID" class="form-control" hidden value="<?php echo set_value('id');?>">
                            <div class="row">
                                <div class="mb-3 col">
                                    <label for="first_name" class="col-form-label">First Name:</label>
                                   <input type="text" id="first_name" name="first_name" placeholder="Enter First Name" class="form-control" value="<?php echo set_value('first_name');?>">
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'first_name') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="last_name" class="col-form-label">Last Name:</label>
                                    <input type="text" id="last_name" name="last_name" placeholder="Enter Last Name" class="form-control" value="<?php echo set_value('last_name');?>">
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'last_name') : '' ?></h6>
                                </div>
                            </div>
                            <div class="row">    
                                <div class="mb-3 col">
                                    <label for="nic" class="col-form-label">Enter NIC:</label>
                                    <input type="text" class="form-control nicno" name="nic" id="nic" placeholder="Enter NIC" value="<?php echo set_value('nic');?>">
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'nic') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="birthday" class="col-form-label">Select Birthday:</label>
                                    <input type="date" class="form-control" name="birthday" id="birthday" placeholder="Select Birthday" max="<?php echo date("Y-m-d"); ?>" value="<?php echo set_value('birthday');?>">
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'birthday') : '' ?></h6>
                                </div>
                                <div class="row">
                                    <div class="mb-3 col">
                                        <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="submit">Submit</button>
                                    </div>                            
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!--- Insert/update: End --->
    </section>
    <?php echo view('includes/footer'); ?>
    <?php
        // Retrieve the flash data
        $session = session();
        $successTitle = $session->getFlashdata('title');
        $successMessage = $session->getFlashdata('message');
        $icon = $session->getFlashdata('icon');
        // Check if flash data exists
        if ($successTitle && $successMessage) {
            // Print the success message with seet alert            
            echo "<script>
                    $(document).ready(function() {
                        swal.fire({
                            title: '$successTitle',
                            text: '$successMessage',
                            icon: '$icon',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                        });
                    });
                </script>";
        }
    ?>
    <script>            
        
        function openSubmitModal()
        {
            var submit_modal = $("#submit_modal");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                submit_modal.modal('show');
            }
        }      

        jQuery(document).ready(function()
         {
            openSubmitModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],

                columnDefs: [
                { 
                    orderable: false, targets: 'nosort' } // Add the 'no-sort' class to the header field you want to disable sorting for
                ]
            });
            Table = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                Table.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    Table.rows().select();        
                } else {
                    Table.rows().deselect(); 
                }
            });
            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });    
        
        //update
        $('body').on('click', '#edit', function ()
         {
            var id = $(this).attr('data-id');
            $.ajax({
                url: 'customer_edit/'+id,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    $('#submit_modal').modal('show');
                    $('#submit_modal #id').val(res.data.id); 
                    $('#submit_modal #first_name').val(res.data.first_name); 
                    $('#submit_modal #last_name').val(res.data.last_name);
                    $('#submit_modal #birthday').val(res.data.birthday);
                    $('#submit_modal #nic').val(res.data.nic);
                },
                    error: function (data) {
                }
            });
        });

        //delete
        $('body').on('click', '#delete', function ()
         {
            var id = $(this).attr('data-id');
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $.get('customer_delete/'+id, function (data) {
                if(data.error)
                    // alert('Can not delete, this record has related information');    
                    swal.fire({
                        title: 'Can not delete',
                        // text: "This record has related information",
                        text: data.message,
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'OK',
		            });
                else
                    swal.fire({
                        title: 'Deleted',
                        text: "This record has deleted Successfully!",
                        icon: 'success',
                        showCancelButton: false,
                        confirmButtonText: 'OK',                       
                    }).then((result) => {
                        location.reload();
                        $('#viewtable tbody #'+ id).remove();
                    });
                  
                      })
                }
             });            
        });  


           //customer disable
           $('body').on('change', '#disable', function () 
        {
            var id = $(this).attr('data-id');
            //  alert(id);
            $.getJSON('enable_customer/'+id, function (data) {                
              location.reload();
                    })
        });
        
        //customer enable
        $('body').on('change', '#enable', function () 
        {
            var id = $(this).attr('data-id');
            $.getJSON('disable_customer/'+id, function (data) {
                location.reload();
            })
        });

        //reset form
        $('#submit_modal').on('hidden.bs.modal', function (e) 
        {
            $(this).find('form').trigger('reset');
            $(this).find('.text-danger').remove();
        });

        // prevent multi submit
        document.querySelector('form').addEventListener('submit', function() 
        {
            document.querySelector('#submit').disabled = true;
        });


        // $(document).ready(function() 
        // {
        //     $('#viewtable').DataTable({
        //         columnDefs: [
        //         { orderable: false, targets: 'no-sort' } // Add the 'no-sort' class to the header field you want to disable sorting for
        //         ]
        //     });
        // });
        //set birthday year limit
        var currentDate = new Date();
        
        // Subtract 12 years from the current date
        var twelveYearsAgo = new Date();
        twelveYearsAgo.setFullYear(currentDate.getFullYear() - 12);
        
        // Format the minimum date as YYYY-MM-DD
        var formattedDate = twelveYearsAgo.toISOString().split('T')[0];
        
        // Set the minimum date attribute of the input element
        $('#birthday').attr('max', formattedDate);
    </script>
<?php $this->endSection() ?>