<?php

namespace App\Models;

use CodeIgniter\Model;

class TenantModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'tenant';
    protected $primaryKey       = 'TID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['TID', 'TName', 'TLogo', 'TBRNo', 'TAddress1', 'TAddress2', 'TCity', 'TProvince', 'TCountry', 'TOwnerName', 'TOwnerNIC', 'TCreatedAt', 'TUpdatedAt', 'TDeletedAt','current_status' ,'delete_flag','TCreatedBy','TUpdatedBy','TDeletedBy'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'TCreatedAt';
    protected $updatedField  = 'TUpdatedAt';
    protected $deletedField  = 'TDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

      // get all data
      function index()
      {
            $data= $this->db->table('tenant')->where('delete_flag', 0)->orderBy('TID', 'ASC')->get()->getResultArray();
            return $data;
      }  
       // get indexActiveData data
       function indexActiveData()
       {
           $data= $this->db->table('tenant')->where('delete_flag', 0)->where('current_status', 1)->orderBy('TID', 'ASC')->get()->getResultArray();
           return $data;
       }  
       // save tenant data
    function insertTenantData($data)
    {
          return $this->db
          ->table('tenant')
          ->insert($data);
    }
        // get signle tenant data
    function getSingleTenantData($id)
    {
          return $this->db
               ->table('tenant')
               ->where(["TID" => $id])
               ->get()
               ->getRow();
    }
    // update tenant
    function updateTenantData($id,$data)
    {
          return $this->db
          ->table('tenant')
          ->where(["TID" => $id])
          ->set($data)
          ->update();
    }
  // delete tenant
    function deleteTenant($id,$data)
      {
            return $this->db
            ->table('tenant')
            ->where(["TID" => $id])
            ->set($data)
            ->update();
      }
   //  status  change
   function statusupdate($id,$data)
      {
            return $this->db
                  ->table('tenant')
                  ->where(["TID" => $id])
                  ->set($data)
                  ->update();
      }
}
