<?php

namespace App\Models;

use CodeIgniter\Model;

class TempReceivingModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'temp_receiving';
    protected $primaryKey       = 'RID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['CartID', 'RType', 'SupplierID', 'UserID', 'RBatchNo', 'RComment', 'RNet', 'RNetwithtax', 'RPaymentType', 'RCreatedAt', 'RUpdatedAt', 'RDeletedAt', 'RStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'RCreatedAt';
    protected $updatedField  = 'RUpdatedAt';
    protected $deletedField  = 'RDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // get index data
    function getIndexData()
    {
        $data= $this->db
            ->table('temp_receiving')
            ->orderBy('RCreatedAt', 'ASC')
            ->get()
            ->getResultArray();

        return $data;
    }

    // insert receiving to db
    function insertRecData($data)
    {   
        $db = db_connect();
        $builder = $db->table($this->table);
 
        $builder->insert($data);
 
        return $db->insertID();  
    }

    // get single Rec data
    function getSingleRecData($id)
    {
        return $this->db
            ->table('temp_receiving')
                // ->join('temp_receivingdetails', 'temp_receiving.CartID = temp_receivingdetails.CartID')
                // ->join('temp_itemserialized', 'temp_receiving.CartID = temp_itemserialized.CartID')
            ->where(["temp_receiving.CartID" => $id])
            ->get()
            //->getResult();
            ->getRow();
    }

    // update temp receiving record
    function updateTempRec($id,$data)
    {
        return $this->db
            ->table('temp_receiving')
            ->where(["CartID" => $id])
            ->set($data)
            ->update();
    }

    // delete previous data
    public function deletePreviousRecRecord($id)
    {
        return $this->db->table('temp_receiving')->where('CartID', $id)->delete();
    }
}
