<?php

namespace App\Models;

use CodeIgniter\Model;

class ReceivingModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'receiving';
    protected $primaryKey       = 'RID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['RType', 'SupplierID', 'UserID', 'RBatchNo', 'RComment', 'RNet', 'RNetwithtax', 'RPaymentType', 'RCreatedAt', 'RUpdatedAt', 'RDeletedAt', 'RStatus','RDeletedBy','RUpdatedBy','RCreatedBy'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'RCreatedAt';
    protected $updatedField  = 'RUpdatedAt';
    protected $deletedField  = 'RDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    function getItemIndexData()
    {
        $data= $this->db
        ->table('item')
        //->where('ItemStatus', '1')
        ->where('delete_flag', '0')
        ->orderBy('ItemID ', 'ASC')
        ->get()
        ->getResultArray();

        return $data;
    }

    function insertItemData($data)
    {   
        return $this->db
            ->table('item')
            ->insert($data);
    }

    // insert receiving to db
    function insertRecData($data)
    {   //var_dump($data);exit();
        $db = db_connect();
        $builder = $db->table($this->table);

        $builder->insert($data);

        return $db->insertID();       
       
    }
    
    // get single item category data
    function getSingleItemData($id)
    {
        return $this->db
            ->table('item')
            ->where(["ItemID " => $id])
            ->get()
            ->getRow();
    }

    // get Receiving data for pdf
    function getSingleRecData($id)
    {
        return $this->db
            ->table('receiving')
            ->where(["RID " => $id])
                ->join('suppliers', 'suppliers.SupplierID = receiving.SupplierID')
                ->join('user', 'user.UserID = receiving.UserID')
            ->get()
            ->getResultArray();
    }
    
    // update employee
    function updateItem($id,$data)
    {
        return $this->db
            ->table('item')
            ->where(["ItemID" => $id])
            ->set($data)
            ->update();

    }
    // delete item
    function deleteitem($id,$data){
        return $this->db
            ->table('receiving')
            ->where(["RID" => $id])
            ->set($data)
            ->update();
    }

    //checkBatchNo
    function checkBatchNo(){
        return $this->db
            ->table('receiving')
            ->orderBy("RBatchNo", "DESC")
            ->limit(1)
            ->get()
            ->getResultArray();
    }
}
