<?php

namespace App\Models;

use CodeIgniter\Model;

class ManufacturerModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'manufacturer';
    protected $primaryKey       = 'MID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['MID', 'MLicNo', 'MImg', 'MCompanyName', 'MName', 'MNIC', 'MAddressLine1', 'MAddressLine2', 'MCity', 'MProvince', 'MCountry', 'MContactNo', 'MEmail', 'MDescription', 'MBankName', 'MBankAcNo', 'MCreaterAt', 'MUpdatedAt', 'MDeletedAt', 'MStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'MCreaterAt';
    protected $updatedField  = 'MUpdatedAt';
    protected $deletedField  = 'MDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    
    // get index data
    function getIndexData(){

        $data= $this->db
        ->table('manufacturer')
        ->where('MStatus', '1')
        ->orderBy('MID', 'ASC')
        ->get()
        ->getResultArray();

        return $data;


    }

    
      // save supplier  data
      function insertManData($data)
      {
        
          return $this->db
                      ->table('manufacturer')
                      ->insert($data);
      }
 
      
 
      // get signle Manufacture data
      function getSingleManData($id){

        return $this->db
             ->table('manufacturer')
             ->where(["MID" => $id])
             ->get()
             ->getRow();

    }
    
    
    function updateMan($id,$data){

        // echo '<pre>';
        // print_r($data);
        // echo 'hi';
        // die();
        return $this->db
        ->table('manufacturer')
        ->where(["MID" => $id])
        ->set($data)
        ->update();

    }

   

    
    // delete employee
    function deleteMan($id,$data){
      
        // die();
        return $this->db
        ->table('manufacturer')
        ->where(["MID" => $id])
        ->set($data)
        ->update();

    }
}
