<?php

namespace App\Models;

use CodeIgniter\Model;

class FunctionalityModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'functionalities';
    protected $primaryKey       = 'FID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['FID', 'FName', 'FCreatedAt','FCreatedBy', 'FUpdatedAt', 'FUpdatedBy','FDeletedAt','FDeletedBy', 'delete_flag','current_status'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'FCreatedAt';
    protected $updatedField  = 'FUpdatedAt';
    protected $deletedField  = 'FDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // get functionality data
    public function getFunctionalitiesIndexData()
    {
        $data= $this->db
            ->table('functionalities')
            ->where('delete_flag', '0')
            ->orderBy('FID', 'ASC')
            ->get()
            ->getResultArray();
        return $data;
    } 


    public function getAllActiveFunctionalitydata()
    {
        $data= $this->db
            ->table('functionalities')
            ->where('delete_flag', '0')
            ->where('current_status', '1')
            ->orderBy('FID', 'ASC')
            ->get()
            ->getResultArray();
        return $data;
    } 

    // save functionality data
    public function insertFunData($data)
	{      
        return $this->db
                    ->table('functionalities')
                    ->insert($data);
	}
    // get single functionality data
    function getSingleFunctionalityData($id)
    {
        return $this->db
             ->table('functionalities')
             ->where(["FID" => $id])
             ->get()
             ->getRow();

    }
     //  status  change
     function statusupdate($id,$data)
     {
            return $this->db
                ->table('functionalities')
                ->where(["FID" => $id])
                ->set($data)
                ->update();
     }
}
