<?php

namespace App\Models;

use CodeIgniter\Model;

class CardPromotionModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'card_promotion';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['bank_name', 'amount', 'start_date', 'end_date','created_at','updated_at', 'deleted_at', 'delete_flag','created_by','updated_by','deleted_by'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
    // get all card promo  data
    function getIndexData(){
        $data= $this->db
        ->table('card_promotion')
        ->join('banks','card_promotion.bank_name = banks.BID')
        ->where('delete_flag', '0')
        ->orderBy('id ', 'ASC')
        ->get()
        ->getResultArray();
        return $data;
    }
    // save card promo  data
    function insertData($data)
	{
        return $this->db
        ->table('card_promotion')
        ->insert($data);
	}
    // get single card promo  data
    function getSingleData($id){
        return $this->db
             ->table('card_promotion')
             ->where(["id" => $id])
             ->get()
             ->getRow();
    }
    // update card promo type 
    function updateData($id,$data){
        return $this->db
        ->table('card_promotion')
        ->where(["id" => $id])
        ->set($data)
        ->update();
    }
    // delete card promo type 
    function deleteData($id,$data){
        return $this->db
        ->table('card_promotion')
        ->where(["id" => $id])
        ->set($data)
        ->update();

    }
}
