<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class PaymentTerms extends Migration
{
    public function up()
    {
         //Create payment terms Table
         $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'payment_term_name' => [
                'type' => 'varchar',
                'constraint' => 255,
                'unique'     => true,
            ],
            'payment_term_value' => [
                'type' => 'int',
            ],
            'created_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'updated_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'deleted_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'current_status' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
                'comment' => 'active: 1,inactive: 2',
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('payment_terms');
    }

    public function down()
    {
        //Drop Table
        $this->forge->dropTable('payment_terms');
    }
}
