<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CustomerLoyalties extends Migration
{
    public function up()
    {
        //Create Table
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'customer_id' => [
                'type' => 'INT',
            ],
            'sale_id'=> [
                'type' => 'INT',
            ],
            'loyalty_percentage' => [
                'type' => 'DECIMAL',
               'constraint' => '10,2',
            ],
            'amount' => [
                'type' => 'DECIMAL',
               'constraint' => '10,2',
            ],
            'exp_date' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'is_cash' => [
                'type' => 'INT',
                'default' => 0,
            ],
            'authorized_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'auth_code'=> [
                'type' => 'varchar',
                'constraint' => 255,
                'null' => true,
            ],
            'is_redeemed' => [
                'type' => 'INT',
                'default' => 0,
            ],
            'created_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'updated_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'deleted_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('customer_loyalties');
    }

    public function down()
    {
        //Drop Table
        $this->forge->dropTable('customer_loyalties');
    }
}
