<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class MasterConfig extends Migration
{
    public function up()
    // create master config Table
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'company_name' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'address' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'contact_number' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'time_zone' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'currency' => [
                'type' => 'INT',
            ],
            'multi_language' => [
                'type' => 'INT',
                'comment' => 'has_multi_language: 1, has_multi_language: 0',
            ],
            'business_type' => [
                'type' => 'INT',
            ],
            'location' => [
                'type' => 'varchar',
                'constraint' => 30,
            ],
            'store_type' => [
                'type' => 'INT',
                'comment' => 'single: 0, multiple: 1,standard:2',
            ],
            'is_serialized' => [
                'type' => 'INT',
                'comment' => 'isserialized: 1, notserialized: 0',
            ],
            'customer_payment_term' => [
                'type' => 'INT',
                'comment' => 'noCustomerPaymentTerm: 1, noCustomerPaymentTerm: 0',
            ],
            'supplier_payment_term' => [
                'type' => 'INT',
                'comment' => 'hasSupplierPaymentTerm: 1, noSupplierPaymentTerm: 0',
            ],
            'payment_type' => [
                'type' => 'INT',
            ],
            'has_exp_mod_date' => [
                'type' => 'INT',
                'comment' => 'hasExpModDate: 1, noExpModDate: 0',
            ],
            'backup_type' => [
                'type' => 'INT',
            ],
            'loyalty_percentage' => [
                'type' => 'DECIMAL',
               'constraint' => '10,2',
            ],
            'loyalty_point_validity_period' => [
                'type' => 'INT',
            ],
            'tax' => [
                'type' => 'varchar',
                'constraint' => 30,
            ],
            'has_online_store' => [
                'type' => 'INT',
                'comment' => 'hasOnlineStore: 1, noOnlineStore: 0',
            ],
            'tenant_id' => [
                'type' => 'INT',
            ],
            'Comment' => [
                'type' => 'varchar',
                'constraint' => 30,
            ],
            'type' => [
                'type' => 'INT',
            ],
            'created_by' => [
                'type' => 'INT',
                'null' => true,
            ],
            'created_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_by' => [
                'type' => 'INT',
                'null' => true,
            ],
            'updated_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_by' => [
                'type' => 'INT',
                'null' => true,
            ],
            'deleted_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('masterConfig');
    }

    public function down()
    {
         //update master config Table
        $this->forge->dropTable('masterConfig');
    }
}
