<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class GiftCard extends Migration
{
    public function up()
    {
         //Create giftcard Table
         $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'sale_id' => [
                'type' => 'INT',
            ],
            'voucher_type' => [
                'type' => 'INT',
                'default' => 1,
                'comment' => 'e-voucher: 0, normal-voucher: 1',
            ],
            'gift_card_name' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'giftcard_issue_date' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'giftcard_expire_date'=> [
                'type' => 'DATE',
                'null' => true,
            ],
            'giftcard_issued_by' => [
                'type' => 'INT',
            ],
            'serial_number' => [
                'type' => 'varchar',
                'constraint' => 255,
                'unique'     => true,
            ],
            'amount' => [
                'type' => 'DECIMAL',
               'constraint' => '10,2',
            ],
            'is_used' => [
                'type' => 'INT',
                'default' => 0,
            ],
            'reference_no' => [
                'type' => 'INT',
                'null' => true,
            ],
            'created_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'updated_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'deleted_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'current_status' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
                'comment' => 'active: 1,inactive: 2',
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('gift_cards');
    }

    public function down()
    {
         //Drop Table
         $this->forge->dropTable('gift_cards');
    }
}
