<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Loyalties extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id'=>[
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'type'=>[
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'margin'=>[
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'rate'=>[
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'created_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'updated_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'deleted_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'current_status' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
                'comment' => 'active: 1,inactive: 2',
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('loyalties');
    }

    public function down()
    {
        //Drop Table
        $this->forge->dropTable('loyalties');
    }
}

