<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Receivingdetails extends Migration
{
    public function up()
    {
         //Create Receiving details Table
         $this->forge->addField([
            'RDID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'RID' => [
                'type' => 'INT',
                'constraint' => 255,
            ],
            'ItemID' => [
                'type' => 'INT',
            ],
            'RDIsSerialized' => [
                'type' => 'INT',
            ],
            'RDLine' => [
                'type' => 'INT',
            ],
            'RDQty' => [
                'type' => 'INT'
            ],
            'RDUnit' => [
                'type' => 'varchar',
                'constraint' => 30,
            ],
            'RDCostPrice' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'RDSellingPrice' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'RDCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RDUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RDDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RDStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('RDID');
        $this->forge->createTable('receivingdetails');
    }

    public function down()
    {
          //Drop receiving Table
          $this->forge->dropTable('receivingdetails');
    }
}
