<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class ItemBins extends Migration
{
    public function up()
    {
        //Create ItemBins Table
        $this->forge->addField([
            'IBID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'ILID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'IBName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ItemID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'BatchNo' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'IBQtyLevel' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'IBCreaterAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'IBCreaterBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'IBUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'IBUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'IBDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'IBDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'IBStatus' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
            ],
        ]);

        $this->forge->addPrimaryKey('IBID');
        $this->forge->createTable('itembins');
    }

    public function down()
    {
        //Drop ItemBins Table
        $this->forge->dropTable('itembins');
    }
}
