<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Tenant extends Migration
{
    public function up()
    {
        //Create Tenant Table
        $this->forge->addField([
            'TID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'TName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TLogo' => [
                'type' => 'varchar',
                'constraint' => 255,
                'null' => true,
            ],
            'TBRNo' => [
                'type' => 'varchar',
                'constraint' => 255,              
            ],
            'TAddress1' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TAddress2' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TCity' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TProvince' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TCountry' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TOwnerName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TOwnerNIC' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'TCreatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'TUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'TUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'TDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'TDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'current_status' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
                'comment' => 'active: 1,inactive: 2',
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('TID');
        $this->forge->createTable('tenant');
    }

    public function down()
    {
        //Drop Tenant Table
        $this->forge->dropTable('tenant');
    }
}
