<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class RuleBook extends Migration
{
    public function up()
    {
        //Create RuleBook Table
        $this->forge->addField([
            'RBID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'RoleID' => [
                'type' => 'INT',
                'null' => true,
            ],
            'UserID' => [
                'type' => 'INT',
                'null' => true,
            ],
            'FID' => [
                'type' => 'LONGTEXT',
            ],
            'Fnames' => [
                'type' => 'LONGTEXT',
            ],
            'RBCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RBCreatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'RBUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RBUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'RBDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RBDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('RBID');
        $this->forge->createTable('rulebook');
    }

    public function down()
    {
        //Drop RuleBook Table
        $this->forge->dropTable('rulebook');
    }
}
