<?php

namespace App\Controllers;
use App\Controllers\BaseController;;
use App\Models\PaymentTermModel;
use App\Models\UserModel;

class PaymentTermController extends BaseController
{
    //construct function
    public function __construct()
    {
        $this->payement_term = new PaymentTermModel();   
        $this->db = \Config\Database::connect();

        helper(['url','form','app']);
    }
    //insert/update data
    public function submit() 
    {
        $user_info = getUserInfo(); 
        $validation = $this->validate([
          
            'payment_term' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter a name',
                ],
            ],
            'payment_term_value' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter a value',
                ],
            ],
        ]);
        $id = $this->request->getVar('id');
        $session = session();
        if($validation){
            if($id == ''){  
                //insert
                $data = [
                    'payment_term_name'  => $this->request->getVar('payment_term'),
                    'payment_term_value'  => $this->request->getVar('payment_term_value'),
                    'created_at' => date('Y-m-d H:i:s'),
                    'created_by' =>  $user_info->UserID,
                ];
                     //set trans status
                $transaction_status = false;
                //---begin transaction---
                $this->db->transBegin();
                $this->payement_term->insertData($data);

                  // Set the success flash message
               if ($this->db->transStatus() === FALSE){
                    //---rollback transaction
                    $this->db->transRollback();
                    $transaction_status = false;
                    // Set the success flash message
                    $session->setFlashdata('title', 'Error');
                    $session->setFlashdata('icon', 'warning');
                    $session->setFlashdata('message', 'Something Went wrong.');  
                }
                else{
                    //---commit transaction
                    $this->db->transCommit();
                    $transaction_status = true;
                // Set the success flash message
                    $session->setFlashdata('title', 'Saved');
                    $session->setFlashdata('icon', 'success');
                    $session->setFlashdata('message', 'Payment Term  details saved successfully.'); 
                }           
            }
            else{   
                //update
                $data = [
                    'payment_term_name'  => $this->request->getVar('payment_term'),
                    'payment_term_value'  => $this->request->getVar('payment_term_value'),
                    'updated_at' => date('Y-m-d H:i:s'),
                    'updated_by' =>  $user_info->UserID,
                ];
                $this->payement_term->updateData($id, $data);
                 // Set the success flash message
                $session->setFlashdata('title', 'Saved');
                $session->setFlashdata('message', 'Payment Term details updated successfully.');
            }
            return $this->response->redirect(site_url('/payment_terms'));
        }
        else{
            $user_info = getUserInfo();
            $records['payment_terms'] = $this->payement_term->index();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Payment Terms',
                'link' => 'payment_terms',
                'sources' => $records,
                'userinfo' => $user_info,
                'has_errors' => $has_errors,
                'validation'=>$this->validator,
            );
            return view('payment_terms', $data);
              
        }
    }
    //get specific data
    public function singleData($id = null)
     {
        $data= $this->payement_term->getSpecificData($id);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
     }
    //get all data
    public function index()
    {
        $user_info = getUserInfo();
        $records['payment_terms'] = $this->payement_term->index();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Payment Terms',
            'link' => 'payment_terms',
            'sources' => $records,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        return view('payment_terms', $data);
    }
    // delete data
    public function delete($id = null)
    {
        $user_info = getUserInfo(); 
        $now = date("Y-m-d H:i:s");
        $data = [
            'deleted_at' => $now,
            'delete_flag' => 1,
            'deleted_by' =>  $user_info->UserID,
        ];
        $this->payement_term->deleteData($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    } 
      // Payment Term disable
      public function disablepaymentterms($id = null)
      {
          $data = [
              'current_status' => '2'
          ];
          if($this->payement_term->statusupdate($id, $data)):                
              echo json_encode(array('status'=>true));
          endif;
      }
      // Payment Term enable
      public function enablepaymentterms($id = null)
      {
          $data = [
              'current_status' => '1'
          ];
          if($this->payement_term->statusupdate($id, $data)):                
              echo json_encode(array('status'=>true));
          endif;
      }
}
