<?php

namespace App\Controllers;
use App\Models\UserModel;
use App\Models\ItemLocationsModel;
use App\Models\ItemBinsModel;
use App\Models\LocationModel;
use App\Models\ItemsModel;
use App\Models\StocksModel;

class ItemLocationsController extends BaseController
{   
    private $ItemLocationsModel = null;
    private $ItemBinsModel = null;
    private $now = null;

    public function __construct()
    {
        $this->ItemLocationsModel = new ItemLocationsModel();
        $this->ItemBinsModel = new ItemBinsModel();
        $this->now = date("Y-m-d H:i:s");
        $this->LocationsModel = new LocationModel();  
        $this->ItemsModel = new ItemsModel();
        $this->StocksModel = new StocksModel();
        helper(['url','form','app']);
    }

    public function index()
    {
        $user_info = getUserInfo();
        $ItemLocations['ItemLocations'] = $this->ItemLocationsModel->getAllLocations();
        $ItemLocationBins = $this->ItemBinsModel->getAllLocationbins();
        $locations = $this->LocationsModel->getAllLocations();
        $Items=$this->ItemsModel->getItemIndexData();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'locations',
            'link' => 'locations',
            'sources' => $ItemLocations,
            'ItemLocationBins' => $ItemLocationBins,
            'Items'=>$Items,
            'locations'=>$locations,
            'userinfo' => $user_info,
            'storingtypes' => 'Bin',
            'has_errors' => $has_errors,
        );
        return view('/locations', $data);
    }
    
    // insert data
    public function insert()
    { 
         $user_info = getUserInfo();
        $validation = $this->validate([ 
            'itemBinLocationId' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select location',
                ],
            ],
            'IBItem' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select item',
                ],
            ],
            // 'IBBatchNo' => [
            //     'rules'=>'required',
            //     'errors'=>[
            //         'required'=>'Please select employee',
            //     ],
            // ],
            'IBQtyLevel' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter bin space value',
                ],
            ],
        ]);
        
        $itemlocationid = $this->request->getVar('itemBinId');
        $session = session();
        if($validation){
            if($itemlocationid == ''){  //Insert Item Location
                $data = [
                    'LocationID'  =>  $this->request->getVar('itemBinLocationId'),
                    'ItemID'  => $this->request->getVar('IBItem'),
                    'BatchNo'  => $this->request->getVar('IBBatchNo'),
                    'ILQtyLevel'  => $this->request->getVar('IBQtyLevel'),
                    'ILStatus' => '1',
                    'ILCreaterAt' => $this->now,
                    'ILCreaterBy' => $user_info->UserID,
                ];
                $this->ItemLocationsModel->insertLocations($data);
                // Set the success flash message
                $session->setFlashdata('title', 'Saved');
                $session->setFlashdata('message', 'Item Location details saved successfully.');
            }else{   //Update Item Location
                $data = [
                    'LocationID' => $this->request->getVar('itemBinLocationId'),
                    'ItemID'  => $this->request->getVar('IBItem'),
                    'BatchNo'  => $this->request->getVar('IBBatchNo'),
                    'ILQtyLevel'  => $this->request->getVar('IBQtyLevel'),
                    'ILUpdatedAt' => $this->now,
                    'ILUpdatedBy' =>$user_info->UserID,
                ];
                  // Set the success flash message
                  $session->setFlashdata('title', 'Saved');
                  $session->setFlashdata('message', 'Item Location details updated successfully.');
                $this->ItemLocationsModel->updateItemLocations($itemlocationid, $data);
            }
        }else{
            $user_info = getUserInfo();
            $ItemLocations['ItemLocations'] = $this->ItemLocationsModel->getAllLocations();
            $ItemLocationBins = $this->ItemBinsModel->getAllLocationbins();
            $locations = $this->LocationsModel->getAllLocations();
            $Items=$this->ItemsModel->getItemIndexData();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'locations',
                'link' => 'locations',
                'sources' => $ItemLocations,
                'ItemLocationBins' => $ItemLocationBins,
                'Items'=>$Items,
                'locations'=>$locations,
                'userinfo' => $user_info,
                'storingtypes' => 'Bin',
                'has_errors' => $has_errors,
                'validation'=>$this->validator,
            );
            return view('/locations', $data);
        }
        return $this->response->redirect(site_url('/locations'));
    } 
    
    //get single data
    public function locationBinSingleData($id = null) 
    {        
        $data=$this->ItemLocationsModel->getSingleLocationData($id);
       
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }
  // stock single data
  public function stockSingleData($id = null) 
  {        
      $data=$this->StocksModel->getSingleStockData($id);
     
      if($data){
          echo json_encode(array("status" => true , 'data' => $data));
      }else{
          echo json_encode(array("status" => false));
      }
  }

    // delete
    public function locationBinDelete($id = null)
    {
       $user_info = getUserInfo();
        $data = [
            'ILDeletedAt' => $this->now,
            'ILDeletedBy' =>$user_info->UserID,
            'ILStatus' => '0',
        ];
        $this->ItemLocationsModel->deleteItemBinLocations($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    } 
}
