<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\CustomerModel;
use App\Models\CommonModel;
use Config\Services;

class CustomerController extends BaseController
{
    //construct function
    public function __construct(){
        $this->customer = new CustomerModel(); 
        $this->common = new CommonModel();             
        helper(['url','form','app']);
        $this->db = \Config\Database::connect();
        $this->validation = Services::validation();
    }
    //insert/update data
    public function submit() 
    {
        $user_info = getUserInfo();
        $validation = $this->validate([
            'first_name' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter customer first name',
                ],
            ],
            'last_name' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter customer last name',
                ],
            ],
            'birthday' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select customer birthday'
                ],
            ],
            'nic' => [
                'rules'=>[
                    'rules'=>'required',
                    'is_unique[customers.nic,id,{id}]',
                    'regex_match[/^[0-9]{9}[vVxX]$/]'
                ],
                'errors'=>[
                    'required'=>'Please enter NIC numbber',
                    'regex_match' => 'Not a valid NIC number.',
                    'is_unique'=>'This NIC already exists!',
                ],
            ],
        ]);

        $id = $this->request->getVar('id');        
        $session = session();
        if($validation){
            if($id == ''){  
                //insert
                $data = [
                    'first_name' => $this->request->getVar('first_name'),
                    'last_name'  => $this->request->getVar('last_name'),
                    'birthday'  => $this->request->getVar('birthday'),
                    'nic'  => $this->request->getVar('nic'),
                    'created_at' => date('Y-m-d H:i:s'),
                    'created_by' =>  $user_info->UserID,
                ];
                   //set trans status
                    $transaction_status = false;
                    //---begin transaction---
                    $this->db->transBegin();
                $this->customer->insertData($data);
                if ($this->db->transStatus() === FALSE){
                    //---rollback transaction
                    $this->db->transRollback();
                    $transaction_status = false;
                       // Set the success flash message
                    $session->setFlashdata('title', 'Error');
                    $session->setFlashdata('icon', 'warning');
                    $session->setFlashdata('message', 'Something Went wrong.');  
                }
                else{
                    //---commit transaction
                    $this->db->transCommit();
                    $transaction_status = true;
                   // Set the success flash message
                    $session->setFlashdata('title', 'Saved');
                    $session->setFlashdata('icon', 'success');
                    $session->setFlashdata('message', 'Customer  details saved successfully.'); 
                } 
            }
            else{   
                //update
                $data = [
                    'first_name' => $this->request->getVar('first_name'),
                    'last_name'  => $this->request->getVar('last_name'),
                    'birthday'  => $this->request->getVar('birthday'),
                    'nic'  => $this->request->getVar('nic'),
                    'updated_at' => date('Y-m-d H:i:s'),
                    'updated_by' =>  $user_info->UserID,
                ];
                $this->customer->updateData($id, $data);
                // Set the success flash message
                $session->setFlashdata('title', 'Updated');
                $session->setFlashdata('message', 'Customer updated successfully.');
            }
            return $this->response->redirect(site_url('/customer'));
        }
        else{
            $user_info = getUserInfo();      
            $data['Customers']=$this->customer->index();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Customers',
                'link' => 'customer',
                'sources' => $data,
                'userinfo' => $user_info,
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
            );
            return view('customer', $data);
        }
    }

    //get specific data
    public function getSpecificData($id = null) 
    {
        $data=$this->customer->getSpecificData($id);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    //get all data
    public function index()
    {
        $user_info = getUserInfo();
        $records['Customer'] = $this->customer->index();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Customer',
            'link' => 'customer',
            'sources' => $records,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        return view('customer', $data);
    }

    // delete data
    public function delete($id = null)
    {
        $user_info = getUserInfo();
        $has_contact_info = $this->common->checkForeignKeyConstraints("customer_contact_information","customer_id",$id,"delete_flag",0);
        $has_customer_loyalty_info = $this->common->checkForeignKeyConstraints("customer_loyalties","customer_id",$id,"delete_flag",0);
        $has_sale_info = $this->common->checkForeignKeyConstraints("sales","customer_id",$id,"delete_flag",0);
        $has_payment_info = $this->common->checkForeignKeyConstraints("payments","customer_id",$id,"delete_flag",0);
        $has_delivery_info = $this->common->checkForeignKeyConstraints("delivery","customer_id",$id,"delete_flag",0);
        //define messages
        $msg_prefix = 'This customer has ';
        $msg_contact_info = 'contact information';
        $msg_customer_loyalty_info = ' customer loyalty information ';
        $msg_sale_info = ' sale information ';
        $msg_payment_info = ' payment information ';
        $msg_delivery_info = ' delivery information ';
        $msg = '';
        if($has_sale_info ){
            $msg = $msg_prefix.$msg_sale_info ;
        }
        else{
            if($has_contact_info ){
                $msg = $msg_prefix.$msg_contact_info;
            }
         
        }
        $data = [
            'deleted_at' => date("Y-m-d H:i:s"),
            'deleted_by' =>  $user_info->UserID,
            'delete_flag' => 1,
        ];
        if($has_contact_info || $has_customer_loyalty_info || $has_delivery_info||  $has_payment_info || $has_sale_info){
            return $this->response->setJSON([
                'error' => true,
                'message' => $msg
                
            ]);
        }
        else{
            $this->customer->deleteData($id, $data);
            return $this->response->setJSON([
                'error' => false,
                'message' => 'Successfully deleted!'
            ]);
        }
    }

     // Payment Term disable
     public function enablecustomer($id = null)
     {
         $data = [
             'current_status' => '1'
         ];

         if($this->customer->statusupdate($id, $data)):                
             echo json_encode(array('status'=>true));
         endif;
     }
     // Payment Term enable
     public function disablecustomer($id = null)
     {
         $data = [
             'current_status' => '2'
         ];

         if($this->customer->statusupdate($id, $data)):                
             echo json_encode(array('status'=>true));
         endif;
     }
}
