<?php

namespace App\Models;

use CodeIgniter\Model;

class RackModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'rack';
    protected $primaryKey       = 'RackID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['RackName', 'AisielID', 'RackCreaterAt', 'RackUpdatedAt', 'RackDeletedAt', 'RackStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'RackCreaterAt';
    protected $updatedField  = 'RackUpdatedAt';
    protected $deletedField  = 'RackDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}
