<?php   
namespace App\Models;

use CodeIgniter\Model;

class PaymentTermModel extends Model{
    protected $DBGroup = 'default';
    protected $table = 'payment_terms';
    protected $primaryKey = 'id';
    protected $useAutoIncrement = true;
    protected $returnType = 'array';
    protected $useSoftDeletes = true;
    protected $allowedFields = ['id', 'payment_term_name','payment_term_value','created_at','created_by','updated_at','updated_by','deleted_at','deleted_by','delete_flag'];

    
    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

 
    // get all data
    function index()
    {
        return 
        $this->db->table('payment_terms')
                 ->where('delete_flag', 0)
                 ->orWhere('delete_flag', '2')
                 ->orderBy('id ', 'ASC')
                 ->get()
                 ->getResultArray();
        
    }
    // get all active data
    function getActiveData()
    {
        return 
        $this->db->table('payment_terms')
                 ->where('delete_flag', 0)
                 ->Where('current_status', '1')
                 ->orderBy('id ', 'ASC')
                 ->get()
                 ->getResultArray();
        
    }
     // insert data
     function insertData($data)
     {
         return $this->db->table('payment_terms')
                          ->insert($data);
     }
     //get specific data
     function getSpecificData($id)
     {
         return $this->db->table('payment_terms')
                         ->where(["id" => $id])
                         ->get()
                         ->getRow();
     }
     // update data
    function updateData($id,$data)
    {
        return $this->db->table('payment_terms')
                        ->where(["id" => $id])
                        ->set($data)
                        ->update();
    }
    // delete 
    function deleteData($id,$data)
    {
        return $this->db->table('payment_terms')
                        ->where(["id" => $id])
                        ->set($data)
                        ->update();
    }
     //  status  change
     function statusupdate($id,$data)
    {
           return $this->db
               ->table('payment_terms')
               ->where(["id" => $id])
               ->set($data)
               ->update();
    }
   
}