<?php

namespace App\Models;

use CodeIgniter\Model;

class LocationModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'locations';
    protected $primaryKey       = 'LocationID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['LocationName', 'WHID', 'ZoneID', 'AisieID', 'RackID', 'ShelfID', 'BinID', 'LCreaterAt', 'LUpdatedAt', 'LDeletedAt', 'LStatus','LCreaterBy','LUpdatedBy','LDeletedBy'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'LCreaterAt';
    protected $updatedField  = 'LUpdatedAt';
    protected $deletedField  = 'LDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // get all locations
      function getAllLocations()
      {
          $data= $this->db
              ->table('locations')
              ->where('LStatus', '1')
              ->orderBy('LocationID ', 'ASC')
              ->get()
              ->getResultArray();
          return $data;
      }
      // save locations data
       function insertLocationsData($data)
      {
        return $this->db
        ->table('locations')
        ->insert($data);
      }
      // get single item locations data
      function getSingleLocationData($id)
      {
        return $this->db
            ->table('locations')
            ->where(["LocationID" => $id])
            ->get()
            ->getRow();
      }
     // update locations
      function updateLocationsData($id,$data)
      {
        return $this->db
            ->table('locations')
            ->where(["LocationID" => $id])
            ->set($data)
            ->update();
      }
       // delete locations
    function deleteLocations($id,$data)
    {
        return $this->db
            ->table('locations')
            ->where(["LocationID" => $id])
            ->set($data)
            ->update();
    }
    }