<?php

namespace App\Models;

use CodeIgniter\Model;

class GiftCardModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'gift_cards';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['giftcard_issue_date', 'giftcard_expire_date', 'giftcard_issued_by', 'created_at', 'updated_at', 'deleted_at', 'delete_flag','created_by','updated_by','deleted_by'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];


    // get all giftcard data
    
    function getIndexData()
    {
        $data= $this->db
        ->table('gift_cards')
        ->where('delete_flag', '0')
        ->orderBy('id ', 'ASC')
        ->get()
        ->getResultArray();
        return $data;
    }

    // save gift card  data
    function insertData($data)
	{
        return $this->db
        ->table('gift_cards')
        ->insert($data);
	}

    // get single gift card  data
    function getSingleData($id)
    {
        return $this->db
             ->table('gift_cards')
             ->where(["id" => $id])
             ->get()
             ->getRow();
    }
    // update gift card 
    function updateData($id,$data)
    {
        $this->db
        ->table('gift_cards')
        ->where(["id" => $id])
        ->set($data)
        ->update();
    }

    // delete gift card 
    function deleteData($id,$data)
    {
        return $this->db
        ->table('gift_cards')
        ->where(["id" => $id])
        ->set($data)
        ->update();

    }
    //check voucher validity
    function checkVoucherValidity($gift_card,$total_amount)
    {
        //get matching record
        $gift_card_data['all_Data'] = $this->db->table('gift_cards')->where(["serial_number" => $gift_card])->where(["delete_flag" => 0])->where(["current_status" => 1])->where(["is_used" => 0])->get()->getRow();
        if($gift_card_data['all_Data'] != null){
            $gift_card_data['voucher_validity'] = true;
            //check for exp date
            $current_date = date('Y-m-d');
            $exp_date = $gift_card_data['all_Data']->giftcard_expire_date;
            if($exp_date < $current_date){
                $gift_card_data['expire_status'] = true;
            }
            else{
                $gift_card_data['expire_status'] = false;
            }
            //check if amount sufficient
            $gift_card_amount = $gift_card_data['all_Data']->amount;
            $gift_card_data['amount'] = $gift_card_amount;
            if((int)$total_amount < (int)$gift_card_amount){
                $gift_card_data['is_sufficient'] = true;
            }
            else{
                $gift_card_data['is_sufficient'] = false;
            }
        }
        else{
            $gift_card_data['voucher_validity'] = false;
            $gift_card_data['expire_status'] = false;
            $gift_card_data['is_sufficient'] = false;
            $gift_card_data['amount'] = 0;
        }
        return $gift_card_data;
    }
    // get specific voucher sale  data
    function getSpecificVoucherSaleData($sale_id)
    {
        return $this->db
             ->table('gift_cards')
             ->where(["sale_id" => $sale_id])
             ->get()
             ->getResultArray();
    }
    
// gift card status  change
function statusupdate($id,$data)
{
    return $this->db
        ->table('gift_cards')
        ->where(["id" => $id])
        ->set($data)
        ->update();
}
}
