<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class TempReceiving extends Migration
{
    public function up()
    {
         //Create Receiving Table
         $this->forge->addField([
            'RID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'CartID' => [
                'type' => 'TEXT',
            ],
            'RType' => [
                'type' => 'INT',
            ],
            'SupplierID' => [
                'type' => 'INT'
            ],
            'UserID' => [
                'type' => 'INT'
            ],
            'RBatchNo' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'RComment' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'RNet' => [
                'type' => 'DECIMAL',
               'constraint' => '10,2',
            ],
            'RNetwithtax' => [
                'type' => 'DECIMAL',
               'constraint' => '10,2',
            ],
            'RPaymentType' => [
                'type' => 'INT',
            ],
            'RCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RCreatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'RUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'RDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'RStatus' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
            ],
        ]);
        $this->forge->addPrimaryKey('RID');
        $this->forge->createTable('temp_receiving');
    }
    public function down()
    {
          //Drop receiving Table
          $this->forge->dropTable('temp_receiving');
    }
}
