<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Rack extends Migration
{
    public function up()
    {
        //Create Rack Table
        $this->forge->addField([
            'RackID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'RackName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'AisielID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'RackCreaterAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RackCreaterBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'RackUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RackUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'RackDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RackDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'RackStatus' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
            ],
        ]);

        $this->forge->addPrimaryKey('RackID');
        $this->forge->createTable('rack');
    }

    public function down()
    {
        //Drop Rack Table
        $this->forge->dropTable('rack');
    }
}
