<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Locations extends Migration
{
    public function up()
    {
        //Create Locations Table
        $this->forge->addField([
            'LocationID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'LocationName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'WHID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ZoneID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'AisieID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'RackID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ShelfID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'BinID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'LCreaterAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'LCreaterBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'LUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'LUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'LDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'LDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'LStatus' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
            ],
        ]);

        $this->forge->addPrimaryKey('LocationID');
        $this->forge->createTable('locations');
    }

    public function down()
    {
        //Drop Locations Table
        $this->forge->dropTable('locations');
    }
}
