<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Banks extends Migration
{
    public function up()
    {
        //Create Banks Table
        $this->forge->addField([
            'BID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'BankName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            // 'BCardType' => [
            //     'type' => 'varchar',
            //     'constraint' => 255,
            // ],
            // 'BRate' => [
            //     'type' => 'DECIMAL',
            //     'constraint' => '10,2',
            // ],
            // 'BStartingDate' => [
            //     'type' => 'DATE',
            // ],
            // 'BEndingDate' => [
            //     'type' => 'DATE',
            // ],
            'BCreatedat' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'BCreatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'BUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'BUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'BDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'BDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'current_status' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
                'comment' => 'active: 1,inactive: 2',
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('BID');
        $this->forge->createTable('banks');
    }

    public function down()
    {
        //Drop Banks Table
        $this->forge->dropTable('banks');
    }
}
