<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Inventory extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'ItemID' => [
                'type'  =>  'INT',
                'auto_increment'    =>  true,
            ],
            'ItemCategory' => [
                'type'  =>  'INT',
            ],
            'ItemAttrbutes' => [
                'type'  =>  'INT',
            ],
            'ItemName' => [
                'type'  =>  'TEXT',
            ],
            'ItemLabelName' => [
                'type'  =>  'TEXT',
            ],
            'ItemSupplierID' => [
                'type'  =>  'INT',
            ],
            'ItemTags' => [
                'type'  =>  'TEXT',
            ],
            'ItemManufacturer' => [
                'type'  =>  'INT',
            ],
            'ItemDescription' => [
                'type'  =>  'TEXT',
            ],
            'ItemWeight' => [
                'type'  =>  'FLOAT',
            ],
            'ItemDimention' => [
                'type'  =>  'TEXT',
            ],
            'ItemQty' => [
                'type'  =>  'INT',
            ],
            'ItemCostPrice' => [
                'type'  =>  'DOUBLE',
            ],
            'ItemSellingPrice' => [
                'type'  =>  'DOUBLE',
            ],
            'ItemReorderLevel' => [
                'type'  =>  'INT',
            ],
            'ItemCurrentQty' => [
                'type'  =>  'INT',
            ],
            'ItemImg' => [
                'type'  =>  'TEXT',
            ],
            'ItemMFD' => [
                'type'  =>  'DATE',
            ],
            'ItemEXP' => [
                'type'  =>  'DATE',
            ],
            'ItemBatchNo' => [
                'type'  =>  'TEXT',
            ],
            'ItemIsSerialized' => [
                'type'  =>  'BOOLEAN',
            ],
            'ItemSerialNos' => [
                'type'  =>  'TEXT',
            ],
            'ItemEntryDate' => [
                'type'  =>  'DATETIME',
            ],
            'current_status' => [
                'type'  =>  'INT',
                'constraint' => 1,
                'default' => 1,
            ],
        ]);

        $this->forge->addPrimaryKey('ItemID');
        $this->forge->createTable('inventory');
    }

    public function down()
    {
        $this->forge->dropTable('inventory');
    }
}
