<?php $this->extend('layouts\master') ?>

    <?php $this->section('items') ?>
        
        <?php echo view('includes/footer'); ?>
        <!---List of items --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row px-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-2 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-trash3-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-pen-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-upc-scan"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <div class="dropdown">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" id="dropdownMenuButton2" data-bs-toggle="dropdown" aria-expanded="false">
                                                        <i class="bi bi-funnel-fill"></i>
                                                    </button>
                                                    <ul class="dropdown-menu linear-bg text-secondary px-2 py-2" aria-labelledby="dropdownMenuButton2">
                                                        <li>
                                                            <a class="dropdown-item text-secondary fw-bold" href="#">
                                                                <div class="form-check">
                                                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                                                    <label class="form-check-label" for="flexCheckDefault"> Low Inventory Items</label>
                                                                </div>
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item text-secondary fw-bold" href="#">
                                                                <div class="form-check">
                                                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckChecked" checked>
                                                                    <label class="form-check-label" for="flexCheckChecked">Serialized Items</label>
                                                                </div>
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item text-secondary fw-bold" href="#">
                                                                <div class="form-check">
                                                                    <input class="form-check-input" type="checkbox" name="ItemIsSerialized" value="1" id="ItemIsSerialized" />
                                                                    <label class="form-check-label" for="ItemIsSerialized">Item Is Serialized</label>
                                                                </div>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="search" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-1 me-1 py-0 text-primary fw-bold">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#itemAddModel"><i class="bi bi-plus-lg fw-bold"></i> New Item </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                        <a href="/item_category_information" class="text-secondary text-decoration-none">    
                                                             Item Category Info
                                                        </a>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle" id="viewtable">
                                        <thead class="text-center text-secondary">
                                            <th class="rounded-start p-2" scope="col">
                                                <span class="all-select-check-box-col rounded">
                                                    <input class="form-check-input selectAll" type="checkbox" value="" id="flexCheckDefault" onclick="javascript:checkAll(this)">
                                                </span>
                                            </th>
                                            <th class="p-2" scope="col">Item Name</th>
                                            <th class="p-2" scope="col">Category</th>
                                            <th class="p-2" scope="col">Default Unit</th>
                                            <th class="p-2" scope="col">Tags</th>
                                            <th class="p-2" scope="col">Reorder Level</th>
                                            <th class="p-2" scope="col">Item is Serialized</th>
                                            <th class="p-2" scope="col">Status</th>
                                            <th class="p-2" scope="col">Action</th>                                           
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">
                                            <?php 
                                                if($sources):
                                                foreach($sources as $source):
                                                    if($source['ItemStatus'] != '0'):                                 
                                            ?>
                                                <tr id="<?php echo $source['ItemID']; ?>">
                                                    <th scope="row">
                                                        <div class="btn-outline-danger text-danger fw-bold h5 text-strock-1">
                                                            <input class="form-check-input select-checkbox" type="checkbox" value="" id="flexCheckDefault">
                                                        </div>
                                                    </th>
                                                    <td><?php echo $source['ItemName']; ?></td>
                                                    <td><?php echo $source['ICName']; ?></td>
                                                    <td><?php echo $source['UnitName']; ?></td>
                                                    <td><?php echo $source['ItemTags']; ?></td>
                                                    <td><?php echo $source['ItemReorderLevel']; ?></td>
                                                    <td>
                                                        <?php 
                                                            if($source['ItemIsSerialized'] == '1'):
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="turnoffserialize" data-id="<?php echo  $source['ItemID']; ?>" checked/>
                                                            </div>
                                                        <?php
                                                            else:
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="turnonserialize" data-id="<?php echo  $source['ItemID']; ?>" />
                                                            </div>
                                                        <?php
                                                            endif;
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <?php 
                                                            if($source['ItemStatus'] == '1'):
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="disableitem" data-id="<?php echo  $source['ItemID']; ?>" checked/>
                                                            </div>
                                                        <?php
                                                            else:
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="enableitem" data-id="<?php echo  $source['ItemID']; ?>" />
                                                            </div>
                                                        <?php
                                                            endif;
                                                        ?>
                                                    </td>                                                    
                                                    <td>
                                                        <button class="btn linear-bg text-secondary px-2 py-0" type="button" id="itemedit" data-bs-toggle="modal" data-id="<?php echo  $source['ItemID']; ?>"  data-bs-target="#itemAddModel">
                                                            <i class="bi bi-pen-fill"></i>
                                                        </button>
                                                        <button class="btn linear-bg text-secondary px-2 py-0" type="button" id="itemdelete"  data-id="<?php echo  $source['ItemID']; ?>" >
                                                            <i class="bi bi-trash3-fill"></i>
                                                        </button>
                                                        
                                                    </td>
                                                </tr>
                                                <?php
                                                    endif;
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- Start Insert and Update items --->
            <div class="modal fade" id="itemAddModel" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header linear-bg">
                            <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Item form detail</h5>
                            <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                         <form action="/itemsave" enctype="multipart/form-data" id="add_item" method="post" accept-charset="utf-8">
                            <div class="row">
                                <div class="mb-3 col">
                                     <input type="hidden" class="form-control mb-3" name="ItemID" id="ItemID"  hidden  value="<?php echo set_value('ItemID');?>">
                                    <input type="text" class="form-control" id="ItemName"  value="<?php echo set_value('ItemName');?>" name="ItemName" placeholder="Enter Item Name">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ItemName') : '' ?></h6>  
                                </div>                                                            
                                <div class="mb-3 col">
                                    <select class="form-control" name="ItemCategory" id="ItemCategory">
                                        <option value="">Please Select the cat</option> 
                                            <?php                                        
                                                if($ItemCategories):
                                                foreach($ItemCategories as $ItemCategory):
                                            ?>                                   
                                            <option value="<?php echo $ItemCategory['ICID']; ?>" <?php echo set_value('ItemCategory') == $ItemCategory['ICID'] ? 'selected' : ''; ?> >
                                                 <?php echo $ItemCategory['ICID'].' - '. $ItemCategory['ICName']; ?></option>                                        
                                            <?php
                                                endforeach;
                                                endif;
                                            ?>
                                    </select>
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ItemCategory') : '' ?></h6>  
                                </div>
                            </div>
                            <div class="row">
                                <div class="mb-3 col">
                                    <input type="text" class="form-control" id="ItemTags"  value="<?php echo set_value('ItemTags');?>"  name="ItemTags" placeholder="Enter Item Tags">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ItemTags') : '' ?></h6>  
                                </div>
                                <div class="mb-3 col">
                                    <input type="text" class="form-control" id="ItemDescription"  value="<?php echo set_value('ItemDescription');?>" name="ItemDescription" placeholder="Enter Item Description">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ItemDescription') : '' ?></h6>  
                                </div>
                            </div>
                            <div class="row">
                                <div class="mb-3 col">                                    
                                    <select class="form-control" name="ItemUnit" id="ItemUnit">                                        
                                        <option value="">Please Select the Unit</option> 
                                        <?php                                        
                                            if($Units):
                                            foreach($Units as $Unit):
                                        ?>
                                        <option value="<?php echo $Unit['UnitID']; ?>"  <?php echo set_value('ItemUnit') == $Unit['UnitID'] ? 'selected' : ''; ?> required >
                                            <?php echo  $Unit['UnitID'] .' - '.$Unit['UnitName']; ?></option>                                    
                                        <?php
                                            endforeach;
                                            endif;
                                        ?>
                                    </select>
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ItemUnit') : '' ?></h6>  
                                </div>
                                <div class="mb-3 col">
                                    <input type="text" class="form-control" id="ItemReorderLevel"  value="<?php echo set_value('ItemReorderLevel');?>" name="ItemReorderLevel" placeholder="Enter Item Reorder Level">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ItemReorderLevel') : '' ?></h6>  
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="wrapper col">
                                    <div class="box">
                                        <div class="js--image-preview">
                                            <img id="design"  class ="" alt="Ad Picture"  style="width:auto; height:100px;"/>
                                        </div>
                                        <div class="upload-options">
                                            <label>
                                                <input type="file" class="image_upload" accept="image/*" name="ItemImg" id="ItemImg ">
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="mb-3 col"> 
                                    <input class="form-check-input" name="ItemIsSerialized" type="checkbox" value="1" id="ItemIsSerialized">
                                    <label class="form-check-label ms-1" for="ItemIsSerialized"> : Item Is Serialized </label>
                                </div>
                            </div>   
                            <div class="modal-footer ">
                            <div class="d-flex align-items-start">
                                <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="submitBtn" onclick="submitForm(e)">Submit</button>
                            </div>
                        </div>   
                    </form>
                        </div>
                    </div>
                </div>
            </div>
    <!--- End Insert and Update items --->       
    </section>
    <script>
         function openItemAddModal(){
            var itemAdd_modal = $("#itemAddModel");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                itemAdd_modal.modal('show');
            }
        }
        $(document).ready(function() {
            openItemAddModal();
            $('#viewtable, #viewtable1').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            ItemTable = $('#viewtable, #viewtable1').DataTable();
            $('#vtSearch').keyup(function(){
                ItemTable.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    ItemTable.rows().select();        
                } else {
                    ItemTable.rows().deselect(); 
                }
            });
        });
        $.extend( DataTable.ext.classes, {
            "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
            "sWrapper": "row text-center ms-auto me-auto mt-2",                    
            "sFilter": "dnone",
        });
        // const Toast = Swal.mixin({
        //     toast: true,
        //     position: 'top-end',
        //     showConfirmButton: false,
        //     timer: 3000,
        //     timerProgressBar: true,
        //     didOpen: (toast) => {
        //         toast.addEventListener('mouseenter', Swal.stopTimer)
        //         toast.addEventListener('mouseleave', Swal.resumeTimer)
        //     }
        // });

        //update items
        $('body').on('click', '#itemedit', function () {
            var ItemID  = $(this).attr('data-id');
            $.ajax({
                url: 'itemedit/'+ItemID ,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    console.log(res.data);
                    $('#itemAddModel').modal('show');
                    $('#add_item #ItemName').val(res.data.ItemName); 
                    $('#add_item #ItemCategory').val(res.data.ItemCategory); 
                    $('#add_item #ItemTags').val(res.data.ItemTags);
                    $('#add_item #ItemDescription').val(res.data.ItemDescription);
                    $('#add_item #ItemReorderLevel   ').val(res.data.ItemReorderLevel);
                    $('#add_item #ItemUnit').val(res.data.ItemUnit);
                    $('#add_item #ItemIsSerialized').val(res.data.ItemIsSerialized);
                    if(res.data.ItemIsSerialized==1){
                        $('#add_item #ItemIsSerialized').prop("checked", true);
                    }
                    $('#add_item #ItemID').val(res.data.ItemID);
                    $('#add_item #design  ').attr('src','/uploads/itemImg/'+ res.data.ItemImg);
                },
                    error: function (data) {
                }
            });
        });

        //delete items
        $('body').on('click', '#itemdelete', function () {
            var ItemID = $(this).attr('data-id');
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'GET',
                        dataType: 'json',
                        url: 'item/delete/'+ItemID,
                        async: false,
                        success: function(data){                      
                            swal.fire({
                                icon: data.icon,
                                title: data.title,
                                text: data.message,
                            });
                            if(data['status'] == 'true'){
                                $('#viewtable #'+ ItemID).remove();
                            }
                        }
                    });
                }
            });          
        });

    
        //items turn off serialize
        $('body').on('change', '#turnoffserialize', function () {
            var itemid = $(this).attr('data-id');
            
            $.getJSON('offserialize/'+itemid, function (data) {                
                location.reload();
                // if(data['status'] == 'true'){
                //     $(this).is(":not(:checked)");
                // }
            })
        });
        
        //items turn on serialize
        $('body').on('change', '#turnonserialize', function () {
            var itemid = $(this).attr('data-id');
            
            $.getJSON('onserialize/'+itemid, function (data) {
                location.reload();
                // if(data['status'] == 'true'){
                //     $(this).is(":checked");
                // }
            })
        }); 

        //items disable
        $('body').on('change', '#disableitem', function () {
            var itemid = $(this).attr('data-id');
            
            $.getJSON('disableitem/'+itemid, function (data) {                
                location.reload();
                // if(data['status'] == 'true'){
                //     $(this).is(":not(:checked)");
                // }
            })
        });
        
        //items enable
        $('body').on('change', '#enableitem', function () {
            var itemid = $(this).attr('data-id');
            
            $.getJSON('enableitem/'+itemid, function (data) {
                location.reload();
                // if(data['status'] == 'true'){
                //     $(this).is(":checked");
                // }
            })
        });
        
          //reset form
          $('#itemAddModel').on('hidden.bs.modal', function (e) {
            // Clear the form fields
            $(this).find('form').trigger('reset');
             $(this).find('.text-danger').remove();
            });
    </script>

<?php $this->endSection() ?>
