<?php $this->extend('layouts\master') ?>

<?php $this->section('functionality') ?>

        <!---List of functionality --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">New Functionality</div>
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#functionalityModal">
                                                        <i class="bi bi-plus-lg fw-bold"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                            <th class="p-2" scope="col">Functionality Name</th>
                                            <th class="p-2" scope="col">Status</th>
                                            <th class="p-2" scope="col">Created At</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                       
                                            <?php 
                                                if($functionalities):
                                                foreach($functionalities as $functionality): 
                                                foreach($functionality as $f): 
                                                
                                            ?>
                                            <tr id="<?php echo $f['FID']; ?>">     
                                                <td><?php echo $f['FName']; ?></td>
                                                <td>
                                                    <?php
                                                        if($f['FStatus'] = 1): echo "Active";
                                                        else: echo "Disable";
                                                        endif;
                                                    ?>
                                                </td>
                                                <td><?php echo $f['FCreatedAt']; ?></td>
                                                <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="functionalityedit" type="button" data-bs-toggle="modal" data-bs-target="#functionalityModal" data-id="<?php echo $f['FID']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="functionalitydelete" type="button" data-id="<?php echo $f['FID']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- start insert and update functionality model -->
        <div class="modal fade" id="functionalityModal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">  Functionality Form</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form method="post" id="functionality" name="add_functionality" action="<?= site_url('/submitFunctionality') ?>">
                            <div class="row">
                                <div class="mb-3 col">
                                <input type="hidden" class="form-control mb-3" name="FID" id="FID"  hidden value="<?php echo set_value('FID');?>">
                                    <input type="text" class="form-control" name="FName" id="FName" placeholder="Enter Functionality Name">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'FName') : '' ?></h6>
                                </div>
                            </div>                   
                            <div class="row">
                                <div class="mb-3 col">
                                    <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold">Submit</button>
                                </div>                            
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
         <!-- end  insert and update functionality model -->
    </section>
    <?php echo view('includes/footer'); ?>
    
    <script>
            function openFunctionModal(){
            var function_modal = $("#functionalityModal");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                function_modal.modal('show');
            }
        }

        $(document).ready(function() {
           openFunctionModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            EmpTable = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                EmpTable.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    EmpTable.rows().select();        
                } else {
                    EmpTable.rows().deselect(); 
                }
            });
            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });

        //Check All
        function checkAll(o) {
            var boxes = document.getElementsByClassName("select-checkbox");
            for (var x = 0; x < boxes.length; x++) {
                var obj = boxes[x];
                if (obj.type == "checkbox") {
                if (obj.name != "check")
                    obj.checked = o.checked;
                }
            }
        }                
            //delete items
            $('body').on('click', '#functionalitydelete', function () {
                var functionalityid = $(this).attr('data-id');
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $('#viewtable tbody #'+ functionalityid).remove();
                    $.ajax({
                        type: 'GET',
                        dataType: 'json',
                        url: 'functionality/delete/'+functionalityid,
                        async: false,
                        success: function(data){                      
                            swal.fire({
                                icon: data.icon,
                                title: data.title,
                                text: data.message,
                            });
                            if(data['status'] == 'true'){
                                $('#viewtable #'+ functionalityid).remove();
                            }
                        }
                    });
                }
            });          
        });

        //update functionality
        $('body').on('click', '#functionalityedit', function () {
            var functionality_id = $(this).attr('data-id');
            $.ajax({
                url: 'functionality/edit/'+functionality_id,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    $('#functionalityModal').modal('show');
                    $('#functionality #FID').val(res.data.FID); 
                    $('#functionality #FName').val(res.data.FName); 
                },
                    error: function (data) {
                }
            });
        });
 
        //reset form
        $('#functionalityModal').on('hidden.bs.modal', function (e) {
            // Clear the form fields
            $(this).find('form').trigger('reset');
             $(this).find('.text-danger').remove();
            });
    </script>
<?php $this->endSection() ?>