<?php

namespace App\Models;

use CodeIgniter\Model;

class ItemsCategoryDetailsModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'itemcategorydetails';
    protected $primaryKey       = 'ICDID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['ICID', 'ICPath', 'ICLink', 'ICDCreatedAt', 'ICDUpdatedAt', 'ICDDeletedAt', 'ICDStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'ICDCreatedAt';
    protected $updatedField  = 'ICDUpdatedAt';
    protected $deletedField  = 'ICDDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // update categories
    function updateItemCatgoryDetails($id,$data){

        return $this->db
            ->table('itemcategorydetails')
            ->where(["ICDID" => $id])
            ->set($data)
            ->update();

    }
}
