<?php

namespace App\Models;

use CodeIgniter\Model;

class DeliveryModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'delivery';
    protected $primaryKey       = 'DelID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['sale_id', 'customer_id', 'emp_id', 'address', 'phone_number', 'estimated_shipping_date', 'estimated_delivery_date', 'actual_shipping_date', 'actual_delivery_date','created_at','updated_at','deleted_at','delete_flag'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // insert data
    function insertData($data)
	{
        return $this->db->table('delivery')->insert($data);
	}
    //get specific data
    function getSpecificData($id){
        return $this->db->table('delivery')->where(["id" => $id])->get()->getRow();
    }
    // get all data
    function index(){
        $data= $this->db->table('delivery')->where('delete_flag', 0)->orderBy('id ', 'ASC')->get()->getResultArray();
        return $data;
    }
    // update data
    function updateData($id,$data){
        return $this->db->table('delivery')->where(["id" => $id])->set($data)->update();
    }
    // delete delete
    function deleteData($id,$data){
        return $this->db->table('delivery')->where(["id" => $id])->set($data)->update();
    }
}
