<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Units extends Migration
{
    public function up()
    {
        //Create Units Table
        $this->forge->addField([
            'UnitID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'UnitName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'UnitAbbreviation' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'UnitCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'UnitUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'UnitDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'UnitStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('UnitID');
        $this->forge->createTable('units');
    }

    public function down()
    {
        //Drop Units Table
        $this->forge->dropTable('units');
    }
}
