<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Itemserialized extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'RefID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'RDID' => [
                'type' => 'INT',
                'constraint' => 255,
            ],   

            'RefSerialNos' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
            'RefComment' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'RefQty' => [
                'type' => 'INT',
               'constraint' => '255',
            ],
            'RefPrice' => [
                'type' => 'DECIMAL',
               'constraint' => '10,2',
            ],
            'RefCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RefUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RefDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RefStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('RefID');
        $this->forge->createTable('Itemserialized');
    }

    public function down()
    {
        //
        $this->forge->dropTable('Itemserialized');
    }
}
