<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Postracking extends Migration
{
    public function up()
    {
        //Create POS Tracking Table
        $this->forge->addField([
            'PTLogID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'PTDateTime' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'POSID' => [
                'type' => 'INT',
            ],
            'UserID' => [
                'type' => 'INT',
            ],
            'PTStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('PTLogID');
        $this->forge->createTable('postracking');
    }

    public function down()
    {
        //Drop POS Tracking Table
        $this->forge->dropTable('postracking');
    }
}
