<?php

    namespace App\Controllers;
    use App\Models\SuppliersModel;
    use App\Models\UserModel;

    class SuppliersController extends BaseController
    {   
        
        public function __construct(){
            $this->supmodel = new SuppliersModel();
            helper(['url','form','app']);
        }

        public function index()
        {
            $sup['supData']=$this->supmodel->getIndexData();
            helper('app'); 
            $has_errors = 'flase';
            $user_info = getUserInfo();
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Suppliers',
                'link' => 'suppliers',
                'sources' => $sup,
                'userinfo' => $user_info,
                'has_errors' => $has_errors,
            );  
            return view('suppliers', $data);
           
        }


         //insert  new supplier
    public function save() {
        $validation = $this->validate([
            'SupplierCompanyName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter name',
                ],
            ],
            'SupplierBRNo' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter BR number',
                ],
            ],
            'SupplierName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter supplier name',
                ],
            ],
            'SupplierNIC' => [
                'rules'=>[
                    'required',
                    'regex_match[/^[0-9]{9}[vVxX]$/]'
                ],
                'errors'=>[
                    'required'=>'Please enter NIC numbber',
                    'regex_match' => 'Not a valid NIC number.',
                ],
            ],
            // 'SupplierCity' => [
            //     'rules'=>'required',
            //     'errors'=>[
            //         'required'=>'Please enter city name',
            //     ],
            // ],
            // 'SupplierProvince' => [
            //     'rules'=>'required',
            //     'errors'=>[
            //         'required'=>'Please enter province name',
            //     ],
            // ],
            // 'SupplierCountry' => [
            //     'rules'=>'required',
            //     'errors'=>[
            //         'required'=>'Please enter country name',
            //     ],
            // ],
            // 'SupplierContactNo' => [
            //     'rules'=>'required|regex_match[/^[0-9]{10}$/]',
            //     'errors'=>[
            //         'required'=>'Please enter contact number',
            //         'regex_match' => 'Contact Number must be a valid 10-digit mobile number.'
            //     ],
            // ],
            // 'SupplierEmail' => [
            //     'rules'=>'required|valid_email',
            //     'errors'=>[
            //         'required'=>'Please enter email address',
            //         'valid_email'=>'Please enter valid email'
            //     ],
            // ],
            // 'SupplierDescription' => [
            //     'rules'=>'required',
            //     'errors'=>[
            //         'required'=>'Please enter discription',
            //     ],
            // ],
            // 'SupplierBankName' => [
            //     'rules'=>'required',
            //     'errors'=>[
            //         'required'=>'Please enter bank  name',
            //     ],
            // ],
            // 'SupplierBankACNo' => [
            //     'rules'=>'required',
            //     'errors'=>[
            //         'required'=>'Please enter bank number ',
            //     ],
            // ],

        ]);
        $suppId = $this->request->getVar('SupplierID');
        if($validation){
            if($suppId == ''){  //insert supplier details
        $data = [
            'SupplierCompanyName' => $_POST['SupplierCompanyName'],
            'SupplierBRNo'=>$_POST['SupplierBRNo'],
            'SupplierName' => $_POST['SupplierName'],
            'SupplierNIC' => $_POST['SupplierNIC'],
            'SupplierAddressLine1' => $_POST['SupplierAddressLine1'],
            'SupplierAddresLine2' => $_POST['SupplierAddressLine2'],
            'SupplierCity' => $_POST['SupplierCity'],
            'SupplierProvince' => $_POST['SupplierProvince'],
            'SupplierCountry' => $_POST['SupplierCountry'],
            'SupplierContactNo' => $_POST['SupplierContactNo'],
            'SupplierEmail' => $_POST['SupplierEmail'],
            'SupplierDescription' => $_POST['SupplierDescription'],
            'SupplierBankName' => $_POST['SupplierBankName'],
            'SupplierBankACNo' => $_POST['SupplierBankACNo'],
            'SupplierCreatedAt' => date('Y-m-d H:i:s'),           
        ];
        if(!empty($_FILES['SuppImg']['name'])){             
            $imageFile = $this->request->getFile('SuppImg');
            $imageFile->move('../public/uploads/supImg');
            $imgDetail =$_FILES['SuppImg'];
            $data['SupplierImg']= $imgDetail ['name'];        
        }
        $this->supmodel->insertSupData($data);
           }
        else{
            $data = [
                'SupplierCompanyName' => $this->request->getVar('SupplierCompanyName'),
                'SupplierBRNo'  => $this->request->getVar('SupplierBRNo'),
                'SupplierName'  => $this->request->getVar('SupplierName'),
                'SupplierNIC'  => $this->request->getVar('SupplierNIC'),
                'SupplierAddressLine1'  => $this->request->getVar('SupplierAddressLine1'),
                'SupplierAddresLine2' => $this->request->getVar('SupplierAddressLine2'),
                'SupplierCity'  => $this->request->getVar('SupplierCity'),
                'SupplierProvince'  => $this->request->getVar('SupplierProvince'),
                'SupplierCountry'  => $this->request->getVar('SupplierCountry'),
                'SupplierContactNo'  => $this->request->getVar('SupplierContactNo'),
                'SupplierDescription'  => $this->request->getVar('SupplierDescription'),
                'SupplierBankName' => $this->request->getVar('SupplierBankName'),
                'SupplierBankACNo'  => $this->request->getVar('SupplierBankACNo'),
                'SupplierUpdatedAt' => date('Y-m-d H:i:s'),
            ];
            if(!empty($_FILES['SuppImg']['name'])){          
                $imageFile = $this->request->getFile('SuppImg');
                $imageFile->move('../public/uploads/supImg');
                $imgDetail =$_FILES['SuppImg'];
                $data['SupplierImg']= $imgDetail ['name'];
            }
                    $this->supmodel->updateSup($suppId, $data);                 
           }
            $this->response->redirect(site_url('/suppliers'));
      }
    else{
            $sup['supData']=$this->supmodel->getIndexData();
            helper('app'); 
            $user_info = getUserInfo();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Suppliers',
                'link' => 'suppliers',
                'sources' => $sup,
                'userinfo' => $user_info,
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
                'SupplierCompanyName' => $_POST['SupplierCompanyName'],
                'SupplierBRNo'=>$_POST['SupplierBRNo'],
                'SupplierName' => $_POST['SupplierName'],
                'SupplierNIC' => $_POST['SupplierNIC'],
                'SupplierAddressLine1' => $_POST['SupplierAddressLine1'],
                'SupplierAddresLine2' => $_POST['SupplierAddressLine2'],
                'SupplierCity' => $_POST['SupplierCity'],
                'SupplierProvince' => $_POST['SupplierProvince'],
                'SupplierCountry' => $_POST['SupplierCountry'],
                'SupplierContactNo' => $_POST['SupplierContactNo'],
                'SupplierEmail' => $_POST['SupplierEmail'],
                'SupplierDescription' => $_POST['SupplierDescription'],
                'SupplierBankName' => $_POST['SupplierBankName'],
                'SupplierBankACNo' => $_POST['SupplierBankACNo'],
                'SupplierCreatedAt' => date('Y-m-d H:i:s'),           
            );       
            return view('suppliers', $data);
       }
    }
         //get single data
        public function singleData($id = null) { 
            $data=$this->supmodel->getSingleSupData($id);
            if($data){                
                echo json_encode(array("status" => true , 'data' => $data));
            }else{            
                echo json_encode(array("status" => false));
            }
        }        
    //update
    public function update(){   
        $id = $this->request->getVar('SupplierID');
        $data = [
            'SupplierCompanyName' => $this->request->getVar('SupplierCompanyName'),
            'SupplierBRNo'  => $this->request->getVar('SupplierBRNo'),
            'SupplierName'  => $this->request->getVar('SupplierName'),
            'SupplierNIC'  => $this->request->getVar('SupplierNIC'),
            'SupplierAddressLine1'  => $this->request->getVar('SupplierAddressLine1'),
            'SupplierAddresLine2' => $this->request->getVar('SupplierAddressLine2'),
            'SupplierCity'  => $this->request->getVar('SupplierCity'),
            'SupplierProvince'  => $this->request->getVar('SupplierProvince'),
            'SupplierCountry'  => $this->request->getVar('SupplierCountry'),
            'SupplierContactNo'  => $this->request->getVar('SupplierContactNo'),
            'SupplierDescription'  => $this->request->getVar('SupplierDescription'),
            'SupplierBankName' => $this->request->getVar('SupplierBankName'),
            'SupplierBankACNo'  => $this->request->getVar('SupplierBankACNo'),
            'SupplierUpdatedAt' => date('Y-m-d H:i:s'),
        ];

        if(!empty($_FILES['SuppImg']['name'])){          
            $imageFile = $this->request->getFile('SuppImg');
            $imageFile->move('../public/uploads/supImg');
            $imgDetail =$_FILES['SuppImg'];
            $data['SupplierImg']= $imgDetail ['name'];
        }

        $result = $this->supmodel->updateSup($id, $data);
        if($result) {
            return $this->response->redirect(site_url('/suppliers'));
        }
        else{
            echo "Something went wrong";
        }
    }


     // delete employee
        public function delete($id = null){
            $now = date("Y-m-d H:i:s");
            $data = [
                'SupplierDeletedAt' => $now,
                'SupplierStatus' => '0',
            ];
            $this->supmodel->deleteSup($id, $data);
            // $model->update($id, $data);
            return $this->response->setJSON([
                'error' => false,
                'message' => 'Successfully deleted!'
            ]);
            return $this->response->redirect(site_url('/suppliers'));
        }




    }
?>