<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\LoyaltiesModel;

class LoyaltiesController extends BaseController
{
    //construct function
    public function __construct(){
        $this->loyalties = new LoyaltiesModel();         
        helper(['url','form','app']);
    }
    //insert/update data
    public function submit() {
        $validation = $this->validate([
            'type' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select type',
                ],
            ],
            'margin' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter margin',
                ],
            ],
            'rate' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter rate',
                ],
            ],
        ]);
        $id = $this->request->getVar('id');
        if($validation){
            if($id == ''){  
                //insert
                $data = [
                    'type' => $this->request->getVar('type'),
                    'margin'  => $this->request->getVar('margin'),
                    'rate'  => $this->request->getVar('rate'),
                    'created_at' => date('Y-m-d H:i:s'),
                ];
                $this->loyalties->insertData($data);
            }
            else{   
                //update
                $data = [
                    'type' => $this->request->getVar('type'),
                    'margin'  => $this->request->getVar('margin'),
                    'rate'  => $this->request->getVar('rate'),
                    'updated_at' => date('Y-m-d H:i:s'),
                ];
                $this->loyalties->updateData($id, $data);
            }
            return $this->response->redirect(site_url('/loyalties'));
        }
        else{
            $user_info = getUserInfo();
            $records['Loyalties'] = $this->loyalties->index();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Loyalties',
                'link' => 'loyalties',
                'sources' => $records,
                'userinfo' => $user_info,
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
            );
            return view('/loyalties', $data);
        }
    }
    //get specific data
    public function getSpecificData($id = null) {
        $data=$this->loyalties->getSpecificData($id);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }
    //get all data
    public function index()
    {
        $user_info = getUserInfo();
        $records['Loyalties'] = $this->loyalties->index();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Loyalties',
            'link' => 'loyalties',
            'sources' => $records,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        return view('loyalties', $data);
    }
    // delete data
    public function delete($id = null){
        $data = [
            'deleted_at' => date("Y-m-d H:i:s"),
            'delete_flag' => 1,
        ];
        $this->loyalties->deleteData($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    } 
}
