<?php

namespace App\Controllers;
use App\Models\UserModel;
use App\Models\FunctionalityModel;

use App\Controllers\BaseController;

class FunctionalityController extends BaseController
{

     //construct function
     public function __construct(){
        $this->functionalityModel = new FunctionalityModel();
        helper(['url','form','app']);
    }

     // insert data
    public function insert() {

        $validation = $this->validate([
            'FName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter value',
                   
                ],
            ],
        ]);

        $fID = $this->request->getVar('FID');
        if($validation){
                if($fID == ''){  //insert functionality details
                $data = [
                    'FName' => $this->request->getVar('FName'),
                    'FStatus' => '1',
                ];
                $this->functionalityModel->insertFunData($data);
            }
                else { //update functionality details
                 $data = [
                    'FName' => $this->request->getVar('FName'),
                    ];        
                $this->functionalityModel->update($fID, $data);
                }
            return $this->response->redirect(site_url('/functionality'));

        }
        else{
            $user_info = getUserInfo();
            $functionalities['Functionalities'] =  $this->functionalityModel->where('FStatus', '1')->orderBy('FID', 'ASC')->findAll();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Functionality',
                'link' => 'functionality',
                'functionalities' => $functionalities,
                'userinfo' => $user_info,
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
                    );
                    return view('/functionality', $data);
         }       
    }

    public function index()
    {
        $user_info = getUserInfo();  
        $functionalities['Functionalities'] =  $this->functionalityModel->where('FStatus', '1')->orderBy('FID', 'ASC')->findAll();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Functionality',
            'link' => 'functionality',
            'functionalities' => $functionalities,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        return view('functionality', $data);
    }
    
    //get single data
    public function singleData($id = null) {
        
        $data =  $this->functionalityModel->where('FID', $id)->first();
       
        if($data){
            echo json_encode(array("status" => true, 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    // delete
    public function delete($id = null){
        $now = date("Y-m-d H:i:s");
        $data = [
            'FDeletedAt' => $now,
            'FStatus' => '0',
        ];
        $this->functionalityModel->update($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    } 
}
